/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.items;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Configuration;
import romelo333.notenoughwands.ProtectedBlocks;
import romelo333.notenoughwands.items.GenericWand;
import romelo333.notenoughwands.network.NetworkInit;
import romelo333.notenoughwands.network.PacketGetProtectedBlockCount;
import romelo333.notenoughwands.network.PacketGetProtectedBlocks;
import romelo333.notenoughwands.network.ReturnProtectedBlockCountHelper;
import romelo333.notenoughwands.network.ReturnProtectedBlocksHelper;
import romelo333.notenoughwands.varia.Tools;

public class ProtectionWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_PROTECT = 0;
    public static final int MODE_UNPROTECT = 1;
    public static final int MODE_CLEAR = 2;
    public static final int MODE_LAST = 2;
    public int blockShowRadius = 10;
    public int maximumProtectedBlocks = 16;
    private final boolean master;
    public static final String[] descriptions = new String[]{"protect", "unprotect", "clear all"};
    private static long tooltipLastTime = 0L;
    private static long lastTime = 0L;

    public ProtectionWand(boolean master) {
        super(100);
        if (master) {
            this.setup("master_protection_wand").xpUsage(0).loot(0);
        } else {
            this.setup("protection_wand").xpUsage(50).loot(1);
        }
        this.master = master;
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg, 200, 100000, 100, 200000, 50, 500000);
        this.blockShowRadius = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_blockShowRadius", this.blockShowRadius, "How far around the player protected blocks will be hilighted").getInt();
        this.maximumProtectedBlocks = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_maximumProtectedBlocks", this.master ? 0 : this.maximumProtectedBlocks, "The maximum number of blocks to protect with this wand (set to 0 for no maximum)").getInt();
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 player, List<class_2561> list, class_1836 b) {
        super.method_7851(stack, player, list, b);
        boolean hasid = stack.method_7969() != null && stack.method_7969().method_10545("id");
        int mode = this.getMode(stack);
        int id = this.getId(stack);
        if (hasid && id != 0 && System.currentTimeMillis() - tooltipLastTime > 250L) {
            tooltipLastTime = System.currentTimeMillis();
            NetworkInit.sendToServer(new PacketGetProtectedBlockCount(id));
        }
        list.add((class_2561)new class_2585(class_124.field_1060 + "Mode: " + descriptions[mode]));
        if (this.master) {
            list.add((class_2561)new class_2585(class_124.field_1054 + "Master wand"));
        } else if (id != 0) {
            list.add((class_2561)new class_2585(class_124.field_1060 + "Id: " + id));
        }
        if (hasid) {
            list.add((class_2561)new class_2585(class_124.field_1060 + "Number of protected blocks: " + ReturnProtectedBlockCountHelper.count));
        }
        list.add((class_2561)new class_2585("Right click to protect or unprotect a block."));
        this.showModeKeyDescription(list, "switch mode");
    }

    @Override
    public void toggleMode(class_1657 player, class_1799 stack) {
        int mode = this.getMode(stack);
        if (++mode > 2) {
            mode = 0;
        }
        Tools.notify(player, "Switched to " + descriptions[mode] + " mode");
        Tools.getTagCompound(stack).method_10569("mode", mode);
    }

    private int getMode(class_1799 stack) {
        return Tools.getTagCompound(stack).method_10550("mode");
    }

    public int getId(class_1799 stack) {
        if (this.master) {
            return -1;
        }
        return Tools.getTagCompound(stack).method_10550("id");
    }

    @Override
    public void renderOverlay(class_1657 player, class_1799 wand, float partialTicks) {
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            NetworkInit.sendToServer(new PacketGetProtectedBlocks());
        }
        if (this.master) {
            ProtectionWand.renderOutlines(player, ReturnProtectedBlocksHelper.childBlocks, 30, 30, 200, partialTicks);
        }
        ProtectionWand.renderOutlines(player, ReturnProtectedBlocksHelper.blocks, 210, 60, 40, partialTicks);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 side = context.method_8038();
        class_1799 stack = context.method_8041();
        if (!world.field_9236) {
            ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
            int id = this.getOrCreateId(stack, world, protectedBlocks);
            int mode = this.getMode(stack);
            if (mode == 0) {
                if (!this.checkUsage(stack, player, 1.0f)) {
                    return class_1269.field_5814;
                }
                if (!protectedBlocks.protect(player, world, pos, id)) {
                    return class_1269.field_5814;
                }
                this.registerUsage(stack, player, 1.0f);
            } else if (mode == 1) {
                if (!protectedBlocks.unprotect(player, world, pos, id)) {
                    return class_1269.field_5814;
                }
            } else {
                int cnt = protectedBlocks.clearProtections(world, id);
                Tools.notify(player, "Cleared " + cnt + " protected blocks");
            }
        }
        return class_1269.field_5812;
    }

    private int getOrCreateId(class_1799 stack, class_1937 world, ProtectedBlocks protectedBlocks) {
        int id = this.getId(stack);
        if (id == 0) {
            id = protectedBlocks.getNewId();
            Tools.getTagCompound(stack).method_10569("id", id);
        }
        return id;
    }
}

