/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3614;
import net.minecraft.class_3965;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Configuration;
import romelo333.notenoughwands.ProtectedBlocks;
import romelo333.notenoughwands.items.BlackListSettings;
import romelo333.notenoughwands.items.GenericWand;
import romelo333.notenoughwands.mcjtylib.BlockTools;
import romelo333.notenoughwands.varia.Tools;

public class SwappingWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_3X3 = 0;
    public static final int MODE_5X5 = 1;
    public static final int MODE_7X7 = 2;
    public static final int MODE_SINGLE = 3;
    public static final int MODE_LAST = 3;
    private float hardnessDistance = 35.0f;
    public static final String[] descriptions = new String[]{"3x3", "5x5", "7x7", "single"};

    public SwappingWand() {
        super(100);
        this.setup("swapping_wand").xpUsage(1).loot(5);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg, 2000, 100000, 500, 200000, 200, 500000);
        this.hardnessDistance = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_hardnessDistance", this.hardnessDistance, "How far away the hardness can be to allow swapping (100 means basically everything allowed)").getDouble();
    }

    @Override
    public void toggleMode(class_1657 player, class_1799 stack) {
        int mode = this.getMode(stack);
        if (++mode > 3) {
            mode = 0;
        }
        Tools.notify(player, "Switched to " + descriptions[mode] + " mode");
        Tools.getTagCompound(stack).method_10569("mode", mode);
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 player, List<class_2561> list, class_1836 b) {
        super.method_7851(stack, player, list, b);
        class_2487 compound = stack.method_7969();
        if (compound == null) {
            list.add((class_2561)new class_2585(class_124.field_1061 + "No selected block"));
        } else if (SwappingWand.isSwappingWithOffHand(stack)) {
            list.add((class_2561)new class_2585(class_124.field_1060 + "Will swap with block in offhand"));
        } else {
            String id = compound.method_10558("block");
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(new class_2960(id));
            if (block != class_2246.field_10124) {
                String name = Tools.getBlockName(block);
                list.add((class_2561)new class_2585(class_124.field_1060 + "Selected block: " + name));
                list.add((class_2561)new class_2585(class_124.field_1060 + "Mode: " + descriptions[compound.method_10550("mode")]));
            }
        }
        list.add((class_2561)new class_2585("Sneak right click to select a block."));
        list.add((class_2561)new class_2585("Right click in empty air to select 'offhand' mode."));
        list.add((class_2561)new class_2585("Right click on block to replace."));
        this.showModeKeyDescription(list, "switch mode");
    }

    private static boolean isSwappingWithOffHand(class_1799 stack) {
        class_2487 compound = stack.method_7969();
        if (compound == null) {
            return false;
        }
        return compound.method_10545("offhand");
    }

    private static void enableSwappingWithOffHand(class_1799 stack) {
        class_2487 compound = stack.method_7969();
        if (compound == null) {
            compound = new class_2487();
            stack.method_7980(compound);
        }
        compound.method_10556("offhand", true);
    }

    private static void disableSwappingWithOffHand(class_1799 stack) {
        class_2487 compound = stack.method_7969();
        if (compound == null) {
            return;
        }
        compound.method_10551("offhand");
    }

    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 hand) {
        class_1799 heldItem = playerIn.method_5998(hand);
        if (!heldItem.method_7960()) {
            if (SwappingWand.isSwappingWithOffHand(heldItem)) {
                SwappingWand.disableSwappingWithOffHand(heldItem);
                if (worldIn.field_9236) {
                    Tools.notify(playerIn, "Switched to swapping with selected block");
                }
            } else {
                SwappingWand.enableSwappingWithOffHand(heldItem);
                if (worldIn.field_9236) {
                    Tools.notify(playerIn, "Switched to swapping with block in offhand");
                }
            }
        }
        return super.method_7836(worldIn, playerIn, hand);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 stack = context.method_8041();
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        class_2338 pos = context.method_8037();
        class_2350 side = context.method_8038();
        if (!world.field_9236) {
            if (player.method_5715()) {
                this.selectBlock(stack, player, world, pos);
            } else {
                this.placeBlock(stack, player, world, pos, side);
            }
        }
        return class_1269.field_5812;
    }

    private void placeBlock(class_1799 stack, class_1657 player, class_1937 world, class_2338 pos, class_2350 side) {
        float hardness;
        class_2248 block;
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        class_2487 tagCompound = stack.method_7969();
        if (tagCompound == null) {
            Tools.error(player, "First select a block by sneaking");
            return;
        }
        if (SwappingWand.isSwappingWithOffHand(stack)) {
            class_1799 off = player.method_6079();
            if (off.method_7960()) {
                Tools.error(player, "You need to hold a block in your offhand!");
                return;
            }
            if (!(off.method_7909() instanceof class_1747)) {
                Tools.error(player, "The item in your offhand cannot be placed!");
                return;
            }
            class_1747 itemBlock = (class_1747)off.method_7909();
            block = itemBlock.method_7711();
            class_2680 s = block.method_9564();
            hardness = s.method_11579((class_1922)world, pos);
        } else {
            String id = tagCompound.method_10558("block");
            block = (class_2248)class_2378.field_11146.method_10223(new class_2960(id));
            hardness = tagCompound.method_10583("hardness");
        }
        class_2680 oldState = world.method_8320(pos);
        class_2248 oldblock = oldState.method_11614();
        double cost = BlackListSettings.getBlacklistCost(oldblock);
        if (cost <= (double)0.001f) {
            Tools.error(player, "It is illegal to swap this block");
            return;
        }
        float blockHardness = oldblock.method_9537(oldState, (class_1922)world, pos);
        if (block == oldblock) {
            return;
        }
        if (blockHardness < -0.1f) {
            Tools.error(player, "This block cannot be swapped!");
            return;
        }
        if (!player.method_7337() && Math.abs(hardness - blockHardness) >= this.hardnessDistance) {
            Tools.error(player, "The hardness of this blocks differs too much to swap!");
            return;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, pos)) {
            Tools.error(player, "This block is protected. You cannot replace it!");
            return;
        }
        Set<class_2338> coordinates = this.findSuitableBlocks(stack, world, side, pos, oldblock);
        boolean notenough = false;
        for (class_2338 coordinate : coordinates) {
            if (!this.checkUsage(stack, player, 1.0f)) {
                return;
            }
            class_1799 consumed = Tools.consumeInventoryItem(class_1792.method_7867((class_2248)block), player.field_7514, player);
            if (!consumed.method_7960()) {
                if (!player.method_7337()) {
                    class_1799 oldblockItem = oldblock.method_9574((class_1922)world, pos, oldState);
                    Tools.giveItem(world, player, pos, oldblockItem);
                }
                Tools.playSound(world, block.method_9573(oldState).method_10594(), (double)coordinate.method_10263(), (double)coordinate.method_10264(), (double)coordinate.method_10260(), 1.0, 1.0);
                world.method_8652(coordinate, class_2246.field_10124.method_9564(), 3);
                BlockTools.placeStackAt(player, consumed, world, coordinate, null);
                player.field_7512.method_7623();
                this.registerUsage(stack, player, 1.0f);
                continue;
            }
            notenough = true;
        }
        if (notenough) {
            Tools.error(player, "You don't have the right block");
        }
    }

    private void selectBlock(class_1799 stack, class_1657 player, class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_11614();
        class_1799 item = block.method_9574((class_1922)world, pos, state);
        class_2487 tagCompound = Tools.getTagCompound(stack);
        String name = Tools.getBlockName(block);
        if (name == null) {
            Tools.error(player, "You cannot select this block!");
        } else {
            double cost = BlackListSettings.getBlacklistCost(block);
            if (cost <= (double)0.001f) {
                Tools.error(player, "It is illegal to swap this block");
                return;
            }
            String id = class_2378.field_11146.method_10221((Object)block).toString();
            tagCompound.method_10582("block", id);
            float hardness = block.method_9537(state, (class_1922)world, pos);
            tagCompound.method_10548("hardness", hardness);
            Tools.notify(player, "Selected block: " + name);
        }
    }

    @Override
    public void renderOverlay(class_1657 player, class_1799 wand, float partialTicks) {
        class_2680 state;
        class_2248 block;
        class_3965 blockResult;
        class_239 mouseOver = class_310.method_1551().field_1765;
        if (mouseOver != null && mouseOver.method_17783() == class_239.class_240.field_1332 && (blockResult = (class_3965)mouseOver).method_17777() != null && blockResult.method_17780() != null && (block = (state = player.method_5770().method_8320(blockResult.method_17777())).method_11614()) != null && block.method_9597(state) != class_3614.field_15959) {
            String wandId = Tools.getTagCompound(wand).method_10558("block");
            class_2248 wandBlock = (class_2248)class_2378.field_11146.method_10223(new class_2960(wandId));
            if (wandBlock == block) {
                return;
            }
            Set<class_2338> coordinates = this.findSuitableBlocks(wand, player.method_5770(), blockResult.method_17780(), blockResult.method_17777(), block);
            SwappingWand.renderOutlines(player, coordinates, 200, 230, 180, partialTicks);
        }
    }

    private Set<class_2338> findSuitableBlocks(class_1799 stack, class_1937 world, class_2350 sideHit, class_2338 pos, class_2248 centerBlock) {
        HashSet<class_2338> coordinates = new HashSet<class_2338>();
        int mode = this.getMode(stack);
        int dim = 0;
        switch (mode) {
            case 3: {
                coordinates.add(pos);
                return coordinates;
            }
            case 0: {
                dim = 1;
                break;
            }
            case 1: {
                dim = 2;
                break;
            }
            case 2: {
                dim = 3;
            }
        }
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        switch (sideHit) {
            case field_11036: 
            case field_11033: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, dx, y, dz, centerBlock, coordinates);
                    }
                }
                break;
            }
            case field_11035: 
            case field_11043: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dy = y - dim; dy <= y + dim; ++dy) {
                        this.checkAndAddBlock(world, dx, dy, z, centerBlock, coordinates);
                    }
                }
                break;
            }
            case field_11034: 
            case field_11039: {
                for (int dy = y - dim; dy <= y + dim; ++dy) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, x, dy, dz, centerBlock, coordinates);
                    }
                }
                break;
            }
        }
        return coordinates;
    }

    private void checkAndAddBlock(class_1937 world, int x, int y, int z, class_2248 centerBlock, Set<class_2338> coordinates) {
        class_2338 pos = new class_2338(x, y, z);
        class_2680 state = world.method_8320(pos);
        if (state.method_11614() == centerBlock) {
            coordinates.add(pos);
        }
    }

    private int getMode(class_1799 stack) {
        return Tools.getTagCompound(stack).method_10550("mode");
    }
}

