/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.block;

import java.util.function.Function;
import net.fabricmc.fabric.impl.tools.ToolManager;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_39;

public class FabricBlockSettings {
    protected final class_2248.class_2251 delegate;
    private final Delegate castDelegate;

    protected FabricBlockSettings(class_3614 material, class_3620 color) {
        this(class_2248.class_2251.method_9639((class_3614)material, (class_3620)color));
    }

    protected FabricBlockSettings(class_2248 base) {
        this(class_2248.class_2251.method_9630((class_2248)base));
    }

    protected FabricBlockSettings(class_2248.class_2251 delegate) {
        this.delegate = delegate;
        this.castDelegate = (Delegate)delegate;
    }

    public static FabricBlockSettings of(class_3614 material) {
        return FabricBlockSettings.of(material, material.method_15803());
    }

    public static FabricBlockSettings of(class_3614 material, class_3620 color) {
        return new FabricBlockSettings(material, color);
    }

    public static FabricBlockSettings of(class_3614 material, class_1767 color) {
        return new FabricBlockSettings(material, color.method_7794());
    }

    public static FabricBlockSettings copy(class_2248 base) {
        return new FabricBlockSettings(base);
    }

    public FabricBlockSettings breakByHand(boolean value) {
        ToolManager.entry(this.delegate).setBreakByHand(value);
        return this;
    }

    public FabricBlockSettings breakByTool(class_3494<class_1792> tag) {
        return this.breakByTool(tag, 0);
    }

    public FabricBlockSettings breakByTool(class_3494<class_1792> tag, int miningLevel) {
        ToolManager.entry(this.delegate).putBreakByTool(tag, miningLevel);
        return this;
    }

    public FabricBlockSettings materialColor(class_3620 color) {
        this.castDelegate.fabric_setMaterialColor(color);
        return this;
    }

    public FabricBlockSettings materialColor(class_1767 color) {
        return this.materialColor(color.method_7794());
    }

    public FabricBlockSettings collidable(boolean value) {
        this.castDelegate.fabric_setCollidable(value);
        return this;
    }

    public FabricBlockSettings noCollision() {
        return this.collidable(false);
    }

    public FabricBlockSettings sounds(class_2498 group) {
        this.castDelegate.fabric_setSoundGroup(group);
        return this;
    }

    public FabricBlockSettings ticksRandomly() {
        this.castDelegate.fabric_setRandomTicks(true);
        return this;
    }

    public FabricBlockSettings lightLevel(int value) {
        this.castDelegate.fabric_setLightLevel(value);
        return this;
    }

    public FabricBlockSettings hardness(float value) {
        this.castDelegate.fabric_setHardness(value);
        return this;
    }

    public FabricBlockSettings resistance(float value) {
        this.castDelegate.fabric_setResistance(value);
        return this;
    }

    public FabricBlockSettings strength(float hardness, float resistance) {
        this.castDelegate.fabric_setHardness(hardness);
        this.castDelegate.fabric_setResistance(resistance);
        return this;
    }

    public FabricBlockSettings breakInstantly() {
        return this.hardness(0.0f);
    }

    public FabricBlockSettings dropsNothing() {
        return this.drops(class_39.field_844);
    }

    public FabricBlockSettings dropsLike(class_2248 block) {
        return this.drops(block.method_9580());
    }

    public FabricBlockSettings drops(class_2960 id) {
        this.castDelegate.fabric_setDropTable(id);
        return this;
    }

    public FabricBlockSettings friction(float value) {
        this.castDelegate.fabric_setFriction(value);
        return this;
    }

    public FabricBlockSettings dynamicBounds() {
        this.castDelegate.fabric_setDynamicBounds(true);
        return this;
    }

    public class_2248.class_2251 build() {
        return this.delegate;
    }

    public <T> T build(Function<class_2248.class_2251, T> function) {
        return function.apply(this.delegate);
    }

    public static interface Delegate {
        public void fabric_setMaterialColor(class_3620 var1);

        public void fabric_setCollidable(boolean var1);

        public void fabric_setSoundGroup(class_2498 var1);

        public void fabric_setLightLevel(int var1);

        public void fabric_setHardness(float var1);

        public void fabric_setResistance(float var1);

        public void fabric_setRandomTicks(boolean var1);

        public void fabric_setFriction(float var1);

        public void fabric_setDropTable(class_2960 var1);

        public void fabric_setDynamicBounds(boolean var1);
    }
}

