/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.entity;

import java.util.function.Function;
import net.fabricmc.fabric.api.entity.EntityTrackingRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1937;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabricEntityTypeBuilder<T extends class_1297> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_1311 category;
    private final Function<? super class_1937, ? extends T> function;
    private boolean saveable = true;
    private boolean summonable = true;
    private int trackingDistance = -1;
    private int updateIntervalTicks = -1;
    private boolean alwaysUpdateVelocity = true;
    private float width = -1.0f;
    private float height = -1.0f;

    protected FabricEntityTypeBuilder(class_1311 category, Function<? super class_1937, ? extends T> function) {
        this.category = category;
        this.function = function;
    }

    public static <T extends class_1297> FabricEntityTypeBuilder<T> create(class_1311 category) {
        return new FabricEntityTypeBuilder<class_1297>(category, w -> null);
    }

    public static <T extends class_1297> FabricEntityTypeBuilder<T> create(class_1311 category, Function<? super class_1937, ? extends T> function) {
        return new FabricEntityTypeBuilder<T>(category, function);
    }

    public FabricEntityTypeBuilder<T> disableSummon() {
        this.summonable = false;
        return this;
    }

    public FabricEntityTypeBuilder<T> disableSaving() {
        this.saveable = false;
        return this;
    }

    public FabricEntityTypeBuilder<T> size(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public FabricEntityTypeBuilder<T> trackable(int trackingDistance, int updateIntervalTicks) {
        return this.trackable(trackingDistance, updateIntervalTicks, true);
    }

    public FabricEntityTypeBuilder<T> trackable(int trackingDistance, int updateIntervalTicks, boolean alwaysUpdateVelocity) {
        this.trackingDistance = trackingDistance;
        this.updateIntervalTicks = updateIntervalTicks;
        this.alwaysUpdateVelocity = alwaysUpdateVelocity;
        return this;
    }

    public class_1299<T> build() {
        if (this.saveable) {
            // empty if block
        }
        class_1299 type = new class_1299(this.function, this.category, this.saveable, this.summonable, null, this.width, this.height);
        if (this.trackingDistance != -1) {
            EntityTrackingRegistry.INSTANCE.register(type, this.trackingDistance, this.updateIntervalTicks, this.alwaysUpdateVelocity);
        }
        return type;
    }
}

