/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.server;

import java.util.stream.Stream;
import net.fabricmc.fabric.impl.server.EntityTrackerStreamAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3208;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class PlayerStream {
    private PlayerStream() {
    }

    public static Stream<class_3222> all(MinecraftServer server) {
        if (server.method_3760() != null) {
            return server.method_3760().method_14571().stream();
        }
        return Stream.empty();
    }

    public static Stream<class_1657> world(class_1937 world) {
        return world.field_9228.stream();
    }

    public static Stream<class_1657> watching(class_1937 world, class_1923 pos) {
        if (!(world instanceof class_3218)) {
            throw new RuntimeException("Only supported on ServerWorld!");
        }
        return ((class_3218)world).method_14178().method_17211(pos, false, false);
    }

    public static Stream<class_1657> watching(class_1297 entity) {
        class_3208 tracker;
        class_1937 world = entity.method_5770();
        if (world instanceof class_3218 && (tracker = ((class_3218)world).method_14180()) instanceof EntityTrackerStreamAccessor) {
            return ((EntityTrackerStreamAccessor)tracker).fabric_getTrackingPlayers(entity);
        }
        return PlayerStream.watching(world, new class_1923((int)(entity.field_5987 / 16.0), (int)(entity.field_6035 / 16.0)));
    }

    public static Stream<class_1657> watching(class_2586 entity) {
        return PlayerStream.watching(entity.method_10997(), entity.method_11016());
    }

    public static Stream<class_1657> watching(class_1937 world, class_2338 pos) {
        return PlayerStream.watching(world, new class_1923(pos));
    }

    public static Stream<class_1657> around(class_1937 world, class_243 vector, double radius) {
        double radiusSq = radius * radius;
        return PlayerStream.world(world).filter(p -> p.method_5707(vector) <= radiusSq);
    }

    public static Stream<class_1657> around(class_1937 world, class_2338 pos, double radius) {
        double radiusSq = radius * radius;
        return PlayerStream.world(world).filter(p -> p.method_5677(pos) <= radiusSq);
    }
}

