/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.keybinding;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.client.keybinding.FabricKeyBinding;
import net.fabricmc.fabric.api.client.keybinding.KeyBindingRegistry;
import net.minecraft.class_304;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyBindingRegistryImpl
implements KeyBindingRegistry {
    public static final KeyBindingRegistryImpl INSTANCE = new KeyBindingRegistryImpl();
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<String, Integer> cachedCategoryMap;
    private List<FabricKeyBinding> fabricKeyBindingList = new ArrayList<FabricKeyBinding>();

    private KeyBindingRegistryImpl() {
    }

    private Map<String, Integer> getCategoryMap() {
        if (this.cachedCategoryMap == null) {
            try {
                Method m = class_304.class.getDeclaredMethod("fabric_getCategoryMap", new Class[0]);
                m.setAccessible(true);
                this.cachedCategoryMap = (Map)m.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.cachedCategoryMap == null) {
                throw new RuntimeException("Cached key binding category map missing!");
            }
        }
        return this.cachedCategoryMap;
    }

    private boolean hasCategory(String categoryName) {
        return this.getCategoryMap().containsKey(categoryName);
    }

    @Override
    public boolean addCategory(String categoryName) {
        Map<String, Integer> map = this.getCategoryMap();
        if (map.containsKey(categoryName)) {
            return false;
        }
        Optional<Integer> largest = map.values().stream().max(Integer::compareTo);
        int largestInt = largest.orElse(0);
        map.put(categoryName, largestInt + 1);
        return true;
    }

    @Override
    public boolean register(FabricKeyBinding binding) {
        for (class_304 class_3042 : this.fabricKeyBindingList) {
            if (class_3042 == binding) {
                return false;
            }
            if (!class_3042.method_1431().equals(binding.method_1431())) continue;
            throw new RuntimeException("Attempted to register two key bindings with equal ID: " + binding.method_1431() + "!");
        }
        if (!this.hasCategory(binding.method_1423())) {
            LOGGER.warn("Tried to register key binding with unregistered category '" + binding.method_1423() + "' - please use addCategory to ensure intended category ordering!");
            this.addCategory(binding.method_1423());
        }
        this.fabricKeyBindingList.add(binding);
        return true;
    }

    public class_304[] process(class_304[] keysAll) {
        ArrayList<class_304> newKeysAll = new ArrayList<class_304>();
        for (class_304 binding : keysAll) {
            if (binding instanceof FabricKeyBinding) continue;
            newKeysAll.add(binding);
        }
        newKeysAll.addAll(this.fabricKeyBindingList);
        return newKeysAll.toArray(new class_304[0]);
    }
}

