/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.container;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.container.ContainerFactory;
import net.fabricmc.fabric.api.container.ContainerProviderRegistry;
import net.fabricmc.fabric.impl.container.SyncIdProvider;
import net.fabricmc.fabric.impl.network.PacketTypes;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContainerProviderImpl
implements ContainerProviderRegistry {
    public static final ContainerProviderImpl INSTANCE = new ContainerProviderImpl();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<class_2960, ContainerFactory<class_1703>> FACTORIES = new HashMap<class_2960, ContainerFactory<class_1703>>();

    @Override
    public void registerFactory(class_2960 identifier, ContainerFactory<class_1703> factory) {
        if (FACTORIES.containsKey(identifier)) {
            throw new RuntimeException("A factory has already been registered as " + identifier.toString());
        }
        FACTORIES.put(identifier, factory);
    }

    @Override
    public void openContainer(class_2960 identifier, class_1657 player, Consumer<class_2540> writer) {
        if (!(player instanceof class_3222)) {
            LOGGER.warn("Please only use ContainerProviderRegistry.openContainer() with server-sided player entities!");
            return;
        }
        this.openContainer(identifier, (class_3222)player, writer);
    }

    @Override
    public void openContainer(class_2960 identifier, class_3222 player, Consumer<class_2540> writer) {
        SyncIdProvider syncIDProvider = (SyncIdProvider)player;
        int syncId = syncIDProvider.fabric_incrementSyncId();
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10812(identifier);
        buf.writeByte(syncId);
        writer.accept(buf);
        player.field_13987.method_14364((class_2596)new class_2658(PacketTypes.OPEN_CONTAINER, buf));
        class_2540 clonedBuf = new class_2540(buf.duplicate());
        clonedBuf.method_10810();
        clonedBuf.readUnsignedByte();
        Object container = this.createContainer(syncId, identifier, (class_1657)player, clonedBuf);
        if (container == null) {
            return;
        }
        player.field_7512 = container;
        player.field_7512.method_7596((class_1712)player);
    }

    public <C extends class_1703> C createContainer(int syncId, class_2960 identifier, class_1657 player, class_2540 buf) {
        ContainerFactory<class_1703> factory = FACTORIES.get(identifier);
        if (factory == null) {
            LOGGER.error("No container factory found for {}!", (Object)identifier.toString());
            return null;
        }
        return (C)factory.create(syncId, identifier, player, buf);
    }
}

