/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.network;

import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.network.PacketConsumer;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.PacketRegistry;
import net.fabricmc.fabric.impl.network.PacketTypes;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;

public abstract class PacketRegistryImpl
implements PacketRegistry {
    protected final Map<class_2960, PacketConsumer> consumerMap = new LinkedHashMap<class_2960, PacketConsumer>();

    PacketRegistryImpl() {
    }

    public static class_2596<?> createInitialRegisterPacket(PacketRegistry registry) {
        PacketRegistryImpl impl = (PacketRegistryImpl)registry;
        return impl.createRegisterTypePacket(PacketTypes.REGISTER, impl.consumerMap.keySet());
    }

    @Override
    public void register(class_2960 id, PacketConsumer consumer) {
        boolean isNew = true;
        if (this.consumerMap.containsKey(id)) {
            isNew = false;
        }
        this.consumerMap.put(id, consumer);
        if (isNew) {
            this.onRegister(id);
        }
    }

    @Override
    public void unregister(class_2960 id) {
        this.consumerMap.remove(id);
        this.onUnregister(id);
    }

    protected abstract void onRegister(class_2960 var1);

    protected abstract void onUnregister(class_2960 var1);

    protected abstract Collection<class_2960> getIdCollectionFor(PacketContext var1);

    protected abstract void onReceivedRegisterPacket(PacketContext var1, Collection<class_2960> var2);

    protected abstract void onReceivedUnregisterPacket(PacketContext var1, Collection<class_2960> var2);

    protected class_2596<?> createRegisterTypePacket(class_2960 id, Collection<class_2960> ids) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        boolean first = true;
        for (class_2960 a : ids) {
            if (!first) {
                buf.writeByte(0);
            } else {
                first = false;
            }
            buf.writeBytes(a.toString().getBytes(StandardCharsets.US_ASCII));
        }
        return this.toPacket(id, buf);
    }

    public boolean accept(class_2960 id, PacketContext context, class_2540 buf) {
        if (id.equals((Object)PacketTypes.REGISTER) || id.equals((Object)PacketTypes.UNREGISTER)) {
            String s;
            HashSet<class_2960> ids = new HashSet<class_2960>();
            StringBuilder sb = new StringBuilder();
            while (buf.readerIndex() < buf.writerIndex()) {
                char c = (char)buf.readByte();
                if (c == '\u0000') {
                    s = sb.toString();
                    if (!s.isEmpty()) {
                        ids.add(new class_2960(s));
                    }
                    sb = new StringBuilder();
                    continue;
                }
                sb.append(c);
            }
            s = sb.toString();
            if (!s.isEmpty()) {
                ids.add(new class_2960(s));
            }
            Collection<class_2960> target = this.getIdCollectionFor(context);
            if (id.equals((Object)PacketTypes.UNREGISTER)) {
                target.removeAll(ids);
                this.onReceivedUnregisterPacket(context, ids);
            } else {
                target.addAll(ids);
                this.onReceivedRegisterPacket(context, ids);
            }
            return false;
        }
        PacketConsumer consumer = this.consumerMap.get(id);
        if (consumer != null) {
            try {
                consumer.accept(context, buf);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return true;
        }
        return false;
    }
}

