/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.network;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.WeakHashMap;
import net.fabricmc.fabric.api.event.network.C2SPacketTypeCallback;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.server.PlayerStream;
import net.fabricmc.fabric.impl.accessors.CustomPayloadC2SPacketAccessor;
import net.fabricmc.fabric.impl.network.PacketRegistryImpl;
import net.fabricmc.fabric.impl.network.PacketTypes;
import net.fabricmc.loader.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2913;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerSidePacketRegistryImpl
extends PacketRegistryImpl
implements ServerSidePacketRegistry {
    private final WeakHashMap<class_1657, Collection<class_2960>> playerPayloadIds = new WeakHashMap();

    public void onQueryResponse(class_2913 packet) {
    }

    @Override
    public boolean canPlayerReceive(class_1657 player, class_2960 id) {
        Collection<class_2960> ids = this.playerPayloadIds.get(player);
        if (ids != null) {
            return ids.contains(id);
        }
        return false;
    }

    @Override
    public void sendToPlayer(class_1657 player, class_2596<?> packet, GenericFutureListener<? extends Future<? super Void>> completionListener) {
        if (!(player instanceof class_3222)) {
            throw new RuntimeException("Can only send to ServerPlayerEntities!");
        }
        ((class_3222)player).field_13987.method_14369(packet, completionListener);
    }

    @Override
    public class_2596<?> toPacket(class_2960 id, class_2540 buf) {
        return new class_2658(id, buf);
    }

    @Override
    protected void onRegister(class_2960 id) {
        MinecraftServer server = FabricLoader.INSTANCE.getEnvironmentHandler().getServerInstance();
        if (server != null) {
            class_2596<?> packet = this.createRegisterTypePacket(PacketTypes.REGISTER, Collections.singleton(id));
            PlayerStream.all(server).forEach(p -> this.sendToPlayer((class_1657)p, packet));
        }
    }

    @Override
    protected void onUnregister(class_2960 id) {
        MinecraftServer server = FabricLoader.INSTANCE.getEnvironmentHandler().getServerInstance();
        if (server != null) {
            class_2596<?> packet = this.createRegisterTypePacket(PacketTypes.UNREGISTER, Collections.singleton(id));
            PlayerStream.all(server).forEach(p -> this.sendToPlayer((class_1657)p, packet));
        }
    }

    @Override
    protected Collection<class_2960> getIdCollectionFor(PacketContext context) {
        return this.playerPayloadIds.computeIfAbsent(context.getPlayer(), p -> new HashSet());
    }

    @Override
    protected void onReceivedRegisterPacket(PacketContext context, Collection<class_2960> ids) {
        C2SPacketTypeCallback.REGISTERED.invoker().accept(context.getPlayer(), ids);
    }

    @Override
    protected void onReceivedUnregisterPacket(PacketContext context, Collection<class_2960> ids) {
        C2SPacketTypeCallback.UNREGISTERED.invoker().accept(context.getPlayer(), ids);
    }

    public final boolean accept(class_2817 packet, PacketContext context) {
        CustomPayloadC2SPacketAccessor accessor = (CustomPayloadC2SPacketAccessor)packet;
        return this.accept(accessor.getChannel(), context, accessor.getData());
    }
}

