/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.impl.registry.ExtendedIdList;
import net.fabricmc.fabric.impl.registry.RegistryListener;
import net.minecraft.class_2361;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class IdListUpdater<K, V>
implements RegistryListener<K> {
    private final class_2361<V> mappers;
    private Map<class_2960, V> mapperCache = new HashMap<class_2960, V>();

    public IdListUpdater(Container<V> container) {
        this(container.getIdListForRegistryUpdating());
    }

    public IdListUpdater(class_2361<V> mappers) {
        this.mappers = mappers;
    }

    @Override
    public void beforeRegistryCleared(class_2378<K> registry) {
        this.mapperCache.clear();
        for (class_2960 id : registry.method_10235()) {
            int rawId = registry.method_10249(registry.method_10223(id));
            Object mapper = this.mappers.method_10200(rawId);
            if (mapper == null) continue;
            this.mapperCache.put(id, mapper);
        }
        ((ExtendedIdList)this.mappers).clear();
    }

    @Override
    public void beforeRegistryRegistration(class_2378<K> registry, int id, class_2960 identifier, K object, boolean isNew) {
        if (this.mapperCache.containsKey(identifier)) {
            this.mappers.method_10203(this.mapperCache.get(identifier), id);
        }
    }

    public static interface Container<V> {
        public class_2361<V> getIdListForRegistryUpdating();
    }
}

