/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resources;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.impl.resources.ModDirectoryResourcePack;
import net.fabricmc.fabric.impl.resources.ModZipResourcePack;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.ModContainer;
import net.fabricmc.loader.ModInfo;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import org.apache.commons.io.IOUtils;

public final class ModResourcePackUtil {
    public static final int PACK_FORMAT_VERSION = 4;

    private ModResourcePackUtil() {
    }

    public static void appendModResourcePacks(List<class_3262> packList, class_3264 type) {
        for (ModContainer container : FabricLoader.INSTANCE.getModContainers()) {
            File file = container.getOriginFile();
            ModResourcePack pack = null;
            if (file.isDirectory()) {
                pack = new ModDirectoryResourcePack(container.getInfo(), file);
            } else {
                String name = file.getName().toLowerCase(Locale.ROOT);
                if (name.endsWith(".zip") || name.endsWith(".jar")) {
                    pack = new ModZipResourcePack(container.getInfo(), file);
                }
            }
            if (pack == null || pack.method_14406(type).isEmpty()) continue;
            packList.add(pack);
        }
    }

    public static boolean containsDefault(ModInfo info, String filename) {
        return "pack.mcmeta".equals(filename) || "pack.png".equals(filename);
    }

    public static InputStream openDefault(ModInfo info, String filename) {
        switch (filename) {
            case "pack.png": {
                return ModResourcePackUtil.class.getClassLoader().getResourceAsStream("assets/fabric/textures/misc/default_icon.png");
            }
            case "pack.mcmeta": {
                String description = info.getName();
                description = description == null ? "" : description.replaceAll("\"", "\\\"");
                String pack = String.format("{\"pack\":{\"pack_format\":4,\"description\":\"%s\"}}", description);
                return IOUtils.toInputStream((String)pack, (Charset)Charsets.UTF_8);
            }
        }
        throw new RuntimeException("Mismatch with .containsDefault(...)!");
    }

    public static String getName(ModInfo info) {
        if (info.getName() != null) {
            return info.getName();
        }
        return "Fabric Mod \"" + info.getId() + "\"";
    }
}

