/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.tools;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.registry.BlockConstructedCallback;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3494;

public final class ToolManager {
    private static final Map<class_2248.class_2251, EntryImpl> entriesPre = new HashMap<class_2248.class_2251, EntryImpl>();
    private static final Map<class_2248, EntryImpl> entries = new HashMap<class_2248, EntryImpl>();

    private ToolManager() {
    }

    private static void onBlockRegistered(class_2248.class_2251 settings, class_2248 block) {
        EntryImpl entry = entriesPre.get(settings);
        if (entry != null) {
            entries.put(block, entry);
        }
    }

    public static Entry entry(class_2248.class_2251 settings) {
        return entriesPre.computeIfAbsent(settings, bb -> new EntryImpl());
    }

    private static Entry entry(class_2248 block) {
        return entries.computeIfAbsent(block, bb -> new EntryImpl());
    }

    @Deprecated
    public static void registerBreakByHand(class_2248 block, boolean value) {
        ToolManager.entry(block).setBreakByHand(value);
    }

    @Deprecated
    public static void registerBreakByTool(class_2248 block, class_3494<class_1792> tag, int miningLevel) {
        ToolManager.entry(block).putBreakByTool(tag, miningLevel);
    }

    private static int getMiningLevel(class_1799 stack) {
        if (stack.method_7909() instanceof class_1831) {
            return ((class_1831)stack.method_7909()).method_8022().method_8024();
        }
        return 0;
    }

    public static TriState handleIsEffectiveOn(class_1799 stack, class_2680 state) {
        EntryImpl entry = entries.get(state.method_11614());
        if (entry != null) {
            class_1792 item = stack.method_7909();
            for (int i = 0; i < entry.tags.length; ++i) {
                if (!item.method_7855(entry.tags[i])) continue;
                return TriState.of(ToolManager.getMiningLevel(stack) >= entry.tagLevels[i]);
            }
            return entry.defaultValue;
        }
        return TriState.DEFAULT;
    }

    static {
        BlockConstructedCallback.EVENT.register(ToolManager::onBlockRegistered);
    }

    private static class EntryImpl
    implements Entry {
        private class_3494<class_1792>[] tags = new class_3494[0];
        private int[] tagLevels = new int[0];
        private TriState defaultValue = TriState.DEFAULT;

        private EntryImpl() {
        }

        @Override
        public void setBreakByHand(boolean value) {
            this.defaultValue = TriState.of(value);
        }

        @Override
        public void putBreakByTool(class_3494<class_1792> tag, int miningLevel) {
            for (int i = 0; i < this.tags.length; ++i) {
                if (this.tags[i] != tag) continue;
                this.tagLevels[i] = miningLevel;
                return;
            }
            class_3494[] newTags = new class_3494[this.tags.length + 1];
            int[] newTagLevels = new int[this.tagLevels.length + 1];
            System.arraycopy(this.tags, 0, newTags, 0, this.tags.length);
            System.arraycopy(this.tagLevels, 0, newTagLevels, 0, this.tagLevels.length);
            newTags[this.tags.length] = tag;
            newTagLevels[this.tagLevels.length] = miningLevel;
            this.tags = newTags;
            this.tagLevels = newTagLevels;
        }
    }

    public static interface Entry {
        public void setBreakByHand(boolean var1);

        public void putBreakByTool(class_3494<class_1792> var1, int var2);
    }
}

