/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.texture;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.client.texture.CustomSpriteLoader;
import net.fabricmc.fabric.api.client.texture.DependentSprite;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.fabric.impl.client.texture.FabricSprite;
import net.minecraft.class_1050;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1079;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1059.class})
public abstract class MixinSpriteAtlasTexture {
    @Shadow
    private static Logger field_5278;
    @Shadow
    private int field_5281;
    private Map<class_2960, class_1058> fabric_injectedSprites;

    @Shadow
    public abstract class_1058 method_4608(class_2960 var1);

    @Redirect(method={"method_18160"}, at=@At(value="NEW", target="net/minecraft/client/texture/Sprite"))
    public class_1058 newSprite(class_2960 id, class_1050 c, class_1079 animationMetadata) {
        if (this.fabric_injectedSprites.containsKey(id)) {
            return this.fabric_injectedSprites.get(id);
        }
        return new FabricSprite(id, c, animationMetadata);
    }

    @ModifyVariable(at=@At(value="INVOKE", target="Lnet/minecraft/client/texture/SpriteAtlasTexture;method_18164(Lnet/minecraft/resource/ResourceManager;Ljava/util/Set;)Ljava/util/Collection;"), method={"stitch"})
    public Set<class_2960> setHook(Set<class_2960> set) {
        this.fabric_injectedSprites = new HashMap<class_2960, class_1058>();
        ClientSpriteRegistryCallback.Registry registry = new ClientSpriteRegistryCallback.Registry(this.fabric_injectedSprites, set::add);
        ClientSpriteRegistryCallback.EVENT.invoker().registerSprites((class_1059)this, registry);
        HashSet<DependentSprite> dependentSprites = new HashSet<DependentSprite>();
        HashSet<class_2960> dependentSpriteIds = new HashSet<class_2960>();
        for (class_2960 class_29602 : set) {
            class_1058 class_10582 = this.fabric_injectedSprites.get(class_29602);
            if (!(class_10582 instanceof DependentSprite)) continue;
            dependentSprites.add((DependentSprite)class_10582);
            dependentSpriteIds.add(class_29602);
        }
        if (!dependentSprites.isEmpty()) {
            int n;
            LinkedHashSet<class_2960> result = new LinkedHashSet<class_2960>();
            for (class_2960 class_29603 : set) {
                if (dependentSpriteIds.contains(class_29603)) continue;
                result.add(class_29603);
            }
            boolean bl = false;
            while (n != result.size() && result.size() < set.size()) {
                n = result.size();
                for (DependentSprite sprite : dependentSprites) {
                    class_2960 id = ((class_1058)sprite).method_4598();
                    if (result.contains(id) || !result.containsAll(sprite.getDependencies())) continue;
                    result.add(id);
                }
            }
            if (result.size() < set.size()) {
                class_128 class_1282 = class_128.method_560((Throwable)new Throwable(), (String)"Resolving sprite dependencies");
                for (DependentSprite sprite : dependentSprites) {
                    class_2960 id = ((class_1058)sprite).method_4598();
                    if (result.contains(id)) continue;
                    class_129 element = class_1282.method_562("Unresolved sprite");
                    element.method_578("Sprite", (Object)id);
                    element.method_578("Dependencies", (Object)Joiner.on((char)',').join(sprite.getDependencies()));
                }
                throw new class_148(class_1282);
            }
            return result;
        }
        return set;
    }

    @Inject(at={@At(value="HEAD")}, method={"loadSprite"}, cancellable=true)
    public void loadSprite(class_3300 manager, class_1058 sprite, CallbackInfoReturnable<Boolean> info) {
        if (sprite instanceof CustomSpriteLoader) {
            try {
                if (!((CustomSpriteLoader)sprite).load(manager, this.field_5281)) {
                    info.setReturnValue((Object)false);
                    info.cancel();
                    return;
                }
            }
            catch (IOException | RuntimeException e) {
                field_5278.error("Unable to load custom sprite {}: {}", (Object)sprite.method_4598(), (Object)e);
                info.setReturnValue((Object)false);
                info.cancel();
                return;
            }
            try {
                sprite.method_4590(this.field_5281);
                info.setReturnValue((Object)true);
                info.cancel();
            }
            catch (Throwable e) {
                field_5278.error("Unable to apply mipmap to custom sprite {}: {}", (Object)sprite.method_4598(), (Object)e);
                info.setReturnValue((Object)false);
                info.cancel();
            }
        }
    }
}

