/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.registry;

import com.google.common.collect.BiMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import net.fabricmc.fabric.impl.registry.ListenableRegistry;
import net.fabricmc.fabric.impl.registry.RegistryListener;
import net.fabricmc.fabric.impl.registry.RemapException;
import net.fabricmc.fabric.impl.registry.RemappableRegistry;
import net.minecraft.class_2348;
import net.minecraft.class_2370;
import net.minecraft.class_2960;
import net.minecraft.class_3513;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2370.class})
public abstract class MixinIdRegistry<T>
implements RemappableRegistry,
ListenableRegistry<T>,
RegistryListener<T> {
    @Shadow
    protected static Logger field_11111;
    @Shadow
    protected class_3513<T> field_11110;
    @Shadow
    protected BiMap<class_2960, T> field_11107;
    @Shadow
    private int field_11109;
    private Object2IntMap<class_2960> initialIdMap;
    private RegistryListener[] listeners;

    @Override
    public void registerListener(RegistryListener<T> listener) {
        if (this.listeners == null) {
            this.listeners = new RegistryListener[]{listener};
        } else {
            RegistryListener[] newListeners = new RegistryListener[this.listeners.length + 1];
            System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
            newListeners[this.listeners.length] = listener;
            this.listeners = newListeners;
        }
    }

    @Inject(method={"set"}, at={@At(value="HEAD")})
    public void setPre(int id, class_2960 identifier, Object object, CallbackInfoReturnable info) {
        class_2370 registry = (class_2370)this;
        if (this.listeners != null) {
            for (RegistryListener listener : this.listeners) {
                listener.beforeRegistryRegistration(registry, id, identifier, object, !this.field_11107.containsKey((Object)identifier));
            }
        }
    }

    @Inject(method={"set"}, at={@At(value="RETURN")})
    public void setPost(int id, class_2960 identifier, Object object, CallbackInfoReturnable info) {
        class_2370 registry = (class_2370)this;
        if (this.listeners != null) {
            for (RegistryListener listener : this.listeners) {
                listener.afterRegistryRegistration(registry, id, identifier, object);
            }
        }
    }

    @Override
    public void remap(Object2IntMap<class_2960> idMap, boolean reallocateMissingEntries) throws RemapException {
        class_2370 registry = (class_2370)this;
        Object defaultValue = null;
        if (registry instanceof class_2348) {
            defaultValue = registry.method_10223(((class_2348)registry).method_10137());
        }
        if (!reallocateMissingEntries && !idMap.keySet().equals(registry.method_10235())) {
            throw new RemapException("Source and destination keys differ!");
        }
        if (this.initialIdMap == null) {
            this.initialIdMap = new Object2IntOpenHashMap();
            for (class_2960 id : registry.method_10235()) {
                this.initialIdMap.put((Object)id, registry.method_10249(registry.method_10223(id)));
            }
        }
        if (reallocateMissingEntries) {
            int maxValue = 0;
            Object2IntOpenHashMap idMapOld = idMap;
            idMap = new Object2IntOpenHashMap();
            for (class_2960 id : idMapOld.keySet()) {
                int v = idMapOld.getInt((Object)id);
                idMap.put((Object)id, v);
                if (v <= maxValue) continue;
                maxValue = v;
            }
            for (class_2960 id : registry.method_10235()) {
                if (idMap.containsKey((Object)id)) continue;
                field_11111.warn("Adding " + id + " to registry.");
                idMap.put((Object)id, ++maxValue);
            }
        }
        if (this.listeners != null) {
            for (RegistryListener listener : this.listeners) {
                listener.beforeRegistryCleared(registry);
            }
        }
        this.field_11110.method_15229();
        this.field_11109 = 0;
        ArrayList<class_2960> idsInOrder = new ArrayList<class_2960>((Collection<class_2960>)idMap.keySet());
        idsInOrder.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)idMap).getInt(arg_0)));
        for (class_2960 identifier : idsInOrder) {
            int id = idMap.getInt((Object)identifier);
            Object object = this.field_11107.get((Object)identifier);
            if (object == null) {
                field_11111.warn(identifier + " missing from registry, but requested!");
                continue;
            }
            this.field_11110.method_15230(object, id);
            if (this.field_11109 <= id) {
                this.field_11109 = id + 1;
            }
            if (this.listeners == null) continue;
            for (RegistryListener listener : this.listeners) {
                listener.beforeRegistryRegistration(registry, id, identifier, object, false);
            }
        }
    }

    @Override
    public void unmap() throws RemapException {
        if (this.initialIdMap != null) {
            this.remap(this.initialIdMap, true);
            this.initialIdMap = null;
        }
    }
}

