/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.api;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lain.mods.skins.api.interfaces.IPlayerProfile;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.api.interfaces.ISkinProvider;
import lain.mods.skins.api.interfaces.ISkinProviderService;

public class SkinProviderAPI {
    public static final ISkinProviderService SKIN = SkinProviderAPI.create();
    public static final ISkinProviderService CAPE = SkinProviderAPI.create();

    public static ISkinProviderService create() {
        return new ISkinProviderService(){
            private final ISkin DUMMY = new ISkin(){

                @Override
                public ByteBuffer getData() {
                    return null;
                }

                @Override
                public String getSkinType() {
                    return null;
                }

                @Override
                public boolean isDataReady() {
                    return false;
                }

                @Override
                public void onRemoval() {
                }

                @Override
                public boolean setRemovalListener(Consumer<ISkin> listener) {
                    return false;
                }

                @Override
                public boolean setSkinFilter(Function<ByteBuffer, ByteBuffer> filter) {
                    return false;
                }
            };
            private final LoadingCache<IPlayerProfile, ISkin> cache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<IPlayerProfile, ISkin>(){

                public void onRemoval(RemovalNotification<IPlayerProfile, ISkin> notification) {
                    ISkin skin = (ISkin)notification.getValue();
                    if (skin != null) {
                        skin.onRemoval();
                    }
                }
            }).build((CacheLoader)new CacheLoader<IPlayerProfile, ISkin>(){

                public ISkin load(final IPlayerProfile key) throws Exception {
                    key.setUpdateListener(profileChangeListener);
                    return new ISkin(){
                        private final Collection<ISkin> skins;
                        {
                            this.skins = providers.stream().map(provider -> provider.getSkin(key)).filter(skin -> skin != null).collect(Collectors.toCollection(ArrayList::new));
                        }

                        private Optional<ISkin> find() {
                            return this.skins.stream().filter(ISkin::isDataReady).findFirst();
                        }

                        @Override
                        public ByteBuffer getData() {
                            return this.find().map(ISkin::getData).orElse(null);
                        }

                        @Override
                        public String getSkinType() {
                            return this.find().map(ISkin::getSkinType).orElse(null);
                        }

                        @Override
                        public boolean isDataReady() {
                            return this.find().map(ISkin::isDataReady).orElse(false);
                        }

                        @Override
                        public void onRemoval() {
                            for (ISkin skin : this.skins) {
                                skin.onRemoval();
                            }
                        }

                        @Override
                        public boolean setRemovalListener(Consumer<ISkin> listener) {
                            boolean any = false;
                            for (ISkin skin : this.skins) {
                                if (!skin.setRemovalListener(listener) || any) continue;
                                any = true;
                            }
                            return any;
                        }

                        @Override
                        public boolean setSkinFilter(Function<ByteBuffer, ByteBuffer> filter) {
                            boolean any = false;
                            for (ISkin skin : this.skins) {
                                if (!skin.setSkinFilter(filter) || any) continue;
                                any = true;
                            }
                            return any;
                        }
                    };
                }
            });
            private final List<ISkinProvider> providers = new CopyOnWriteArrayList<ISkinProvider>();
            private final Consumer<IPlayerProfile> profileChangeListener = profile -> {
                if (this.cache.getIfPresent(profile) != null) {
                    this.cache.refresh(profile);
                }
            };

            @Override
            public void clearProviders() {
                this.providers.clear();
                this.cache.invalidateAll();
            }

            @Override
            public ISkin getSkin(IPlayerProfile profile) {
                if (profile == null) {
                    return this.DUMMY;
                }
                return (ISkin)this.cache.getUnchecked((Object)profile);
            }

            @Override
            public boolean registerProvider(ISkinProvider provider) {
                if (provider == null || provider == this) {
                    return false;
                }
                return this.providers.add(provider);
            }
        };
    }
}

