/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.init.fabric;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import java.io.BufferedWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import lain.mods.skins.api.SkinProviderAPI;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.impl.ConfigOptions;
import lain.mods.skins.impl.LegacyConversion;
import lain.mods.skins.impl.PlayerProfile;
import lain.mods.skins.impl.fabric.CustomSkinTexture;
import lain.mods.skins.providers.CrafatarCachedCapeProvider;
import lain.mods.skins.providers.CrafatarCachedSkinProvider;
import lain.mods.skins.providers.CustomServerCachedCapeProvider;
import lain.mods.skins.providers.CustomServerCachedSkinProvider;
import lain.mods.skins.providers.MojangCachedCapeProvider;
import lain.mods.skins.providers.MojangCachedSkinProvider;
import lain.mods.skins.providers.UserManagedCapeProvider;
import lain.mods.skins.providers.UserManagedSkinProvider;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.event.client.ClientTickCallback;
import net.minecraft.class_1062;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class FabricOfflineSkins
implements ClientModInitializer {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Set<String> DefaultSkins = ImmutableSet.of((Object)"textures/entity/steve.png", (Object)"textures/entity/alex.png");
    private static final Map<ByteBuffer, CustomSkinTexture> textures = new WeakHashMap<ByteBuffer, CustomSkinTexture>();
    private static boolean skinPass = false;
    private static boolean capePass = false;
    private static boolean overwrite = true;

    private static class_2960 generateRandomLocation() {
        return new class_2960("offlineskins", String.format("textures/generated/%s", UUID.randomUUID().toString()));
    }

    public static class_2960 getLocationCape(GameProfile profile, class_2960 result) {
        ISkin skin;
        if (capePass) {
            return null;
        }
        if ((overwrite || FabricOfflineSkins.isDefaultSkin(result)) && (skin = SkinProviderAPI.CAPE.getSkin(PlayerProfile.wrapGameProfile(profile))) != null && skin.isDataReady()) {
            return FabricOfflineSkins.getOrCreateTexture(skin.getData(), skin).getLocation();
        }
        return null;
    }

    public static class_2960 getLocationSkin(GameProfile profile, class_2960 result) {
        ISkin skin;
        if (skinPass) {
            return null;
        }
        if ((overwrite || FabricOfflineSkins.isDefaultSkin(result)) && (skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(profile))) != null && skin.isDataReady()) {
            return FabricOfflineSkins.getOrCreateTexture(skin.getData(), skin).getLocation();
        }
        return null;
    }

    private static CustomSkinTexture getOrCreateTexture(ByteBuffer data, ISkin skin) {
        if (!textures.containsKey(data)) {
            CustomSkinTexture texture = new CustomSkinTexture(FabricOfflineSkins.generateRandomLocation(), data);
            class_310.method_1551().method_1531().method_4616(texture.getLocation(), (class_1062)texture);
            textures.put(data, texture);
            if (skin != null) {
                skin.setRemovalListener(s -> {
                    if (data == s.getData()) {
                        class_310.method_1551().execute(() -> {
                            class_310.method_1551().method_1531().method_4615(texture.getLocation());
                            textures.remove(data);
                        });
                    }
                });
            }
        }
        return textures.get(data);
    }

    public static String getSkinType(GameProfile profile, String result) {
        ISkin skin;
        class_2960 location = FabricOfflineSkins.getLocationSkin(profile, null);
        if (location != null && (skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(profile))) != null && skin.isDataReady()) {
            return skin.getSkinType();
        }
        return null;
    }

    private static boolean isDefaultSkin(class_2960 id) {
        return "minecraft".equals(id.method_12836()) && DefaultSkins.contains(id.method_12832());
    }

    public void onInitializeClient() {
        ClientTickCallback.EVENT.register(mc -> {
            if (mc.field_1687 != null) {
                for (class_1657 player : mc.field_1687.field_9228) {
                    SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(player.method_7334()));
                    SkinProviderAPI.CAPE.getSkin(PlayerProfile.wrapGameProfile(player.method_7334()));
                }
            }
        });
        this.reloadConfig();
    }

    public void reloadConfig() {
        Path pathToConfig = Paths.get(".", "config", "offlineskins.json");
        pathToConfig.toFile().getParentFile().mkdirs();
        if (!pathToConfig.toFile().exists()) {
            try (BufferedWriter w = Files.newBufferedWriter(pathToConfig, StandardCharsets.UTF_8, new OpenOption[0]);){
                gson.toJson((Object)new ConfigOptions().defaultOptions(), (Appendable)w);
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.err.println("[OfflineSkins] Failed to write default config file.");
            }
        }
        ConfigOptions config = null;
        try {
            config = (ConfigOptions)gson.fromJson(Files.lines(pathToConfig, StandardCharsets.UTF_8).collect(Collectors.joining(System.getProperty("line.separator"))), ConfigOptions.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("[OfflineSkins] Failed to read config file.");
            config = new ConfigOptions();
        }
        config.validate();
        SkinProviderAPI.SKIN.clearProviders();
        SkinProviderAPI.SKIN.registerProvider(new UserManagedSkinProvider(Paths.get(".", "cachedImages")).withFilter(LegacyConversion.createFilter()));
        if (config.useCustomServer) {
            SkinProviderAPI.SKIN.registerProvider(new CustomServerCachedSkinProvider(Paths.get(".", "cachedImages", "custom"), config.hostCustomServer).withFilter(LegacyConversion.createFilter()));
        }
        if (config.useMojang) {
            SkinProviderAPI.SKIN.registerProvider(new MojangCachedSkinProvider(Paths.get(".", "cachedImages", "mojang")).withFilter(LegacyConversion.createFilter()));
        }
        if (config.useCrafatar) {
            SkinProviderAPI.SKIN.registerProvider(new CrafatarCachedSkinProvider(Paths.get(".", "cachedImages", "crafatar")).withFilter(LegacyConversion.createFilter()));
        }
        SkinProviderAPI.CAPE.clearProviders();
        SkinProviderAPI.CAPE.registerProvider(new UserManagedCapeProvider(Paths.get(".", "cachedImages")));
        if (config.useCustomServer) {
            SkinProviderAPI.CAPE.registerProvider(new CustomServerCachedCapeProvider(Paths.get(".", "cachedImages", "custom"), config.hostCustomServer));
        }
        if (config.useMojang) {
            SkinProviderAPI.CAPE.registerProvider(new MojangCachedCapeProvider(Paths.get(".", "cachedImages", "mojang")));
        }
        if (config.useCrafatar) {
            SkinProviderAPI.CAPE.registerProvider(new CrafatarCachedCapeProvider(Paths.get(".", "cachedImages", "crafatar")));
        }
    }
}

