/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.providers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.channels.Channels;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lain.mods.skins.impl.Shared;

public class CachedDownloader {
    private int _cacheMinTTL = 600;
    private Map<String, String> _dataStore;
    private Predicate<Integer> _handler = code -> true;
    private Predicate<byte[]> _validator;
    private File _local;
    private int _maxTries = 5;
    private Proxy _proxy;
    private URL _remote;

    public static CachedDownloader create() {
        return new CachedDownloader();
    }

    private CachedDownloader() {
    }

    /*
     * Unable to fully structure code
     */
    private final byte[] doRead() {
        if (this._local == null || this._remote == null || this._dataStore == null) {
            return null;
        }
        if (this._local.exists() && (this._local.isDirectory() || !this._local.canRead() || !this._local.canWrite())) {
            return null;
        }
        key = Integer.toHexString(this._local.hashCode());
        metadata = this._dataStore.getOrDefault(key, "0:0:").split(":", 3);
        size = 0L;
        expire = 0L;
        etag = "";
        if (metadata.length == 3) {
            try {
                size = Long.parseLong(metadata[0]);
                expire = Long.parseLong(metadata[1]);
                etag = metadata[2];
            }
            catch (NumberFormatException e) {
                size = 0L;
                expire = 0L;
                etag = "";
            }
        }
        tries = 0;
        while (tries++ < this._maxTries) {
            try {
                block43: {
                    block44: {
                        expired = this._local.exists() && size == this._local.length() ? System.currentTimeMillis() > expire : true;
                        conn = this._proxy == null ? this._remote.openConnection() : this._remote.openConnection(this._proxy);
                        conn.setConnectTimeout(30000);
                        conn.setReadTimeout(10000);
                        if (!expired && !etag.isEmpty()) {
                            conn.setRequestProperty("If-None-Match", etag);
                        }
                        conn.connect();
                        if (!(conn instanceof HttpURLConnection)) break block44;
                        c = (HttpURLConnection)conn;
                        code = c.getResponseCode();
                        switch (code / 100) {
                            case 4: {
                                return null;
                            }
                            case 2: {
                                fos = new FileOutputStream(this._local);
                                var14_18 = null;
                                fos.getChannel().transferFrom(Channels.newChannel(conn.getInputStream()), 0L, 0x7FFFFFFFFFFFFFFFL);
                                if (fos == null) break block43;
                                if (var14_18 == null) ** GOTO lbl50
                                try {
                                    fos.close();
                                }
                                catch (Throwable var15_19) {
                                    var14_18.addSuppressed(var15_19);
                                }
                                break;
lbl50:
                                // 1 sources

                                fos.close();
                                break;
                                catch (Throwable var15_20) {
                                    try {
                                        var14_18 = var15_20;
                                        throw var15_20;
                                    }
                                    catch (Throwable var16_21) {
                                        if (fos != null) {
                                            if (var14_18 != null) {
                                                try {
                                                    fos.close();
                                                }
                                                catch (Throwable var17_22) {
                                                    var14_18.addSuppressed(var17_22);
                                                }
                                            } else {
                                                fos.close();
                                            }
                                        }
                                        throw var16_21;
                                    }
                                }
                            }
                            default: {
                                if (code != 304 && !this._handler.test(code)) {
                                    return null;
                                }
                                break block43;
                            }
                        }
                        break block43;
                    }
                    fos = new FileOutputStream(this._local);
                    code = null;
                    try {
                        fos.getChannel().transferFrom(Channels.newChannel(conn.getInputStream()), 0L, 0x7FFFFFFFFFFFFFFFL);
                    }
                    catch (Throwable fos) {
                        code = fos;
                        throw fos;
                    }
                    finally {
                        if (fos != null) {
                            if (code != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable fos) {
                                    code.addSuppressed(fos);
                                }
                            } else {
                                fos.close();
                            }
                        }
                    }
                }
                cacheControl = this.parseField(conn.getHeaderField("Cache-Control"));
                if (!cacheControl.containsKey("no-cache")) {
                    etag = conn.getHeaderField("Etag");
                    age = 0;
                    try {
                        if (cacheControl.containsKey("max-age")) {
                            age = Integer.parseInt(cacheControl.get("max-age"));
                        }
                    }
                    catch (NumberFormatException e) {
                        age = 0;
                    }
                    expire = Math.max(age > 0 ? System.currentTimeMillis() + (long)(age * 1000) : conn.getExpiration(), System.currentTimeMillis() + (long)(this._cacheMinTTL * 1000));
                    size = this._local.length();
                    this._dataStore.put(key, size + ":" + expire + ":" + etag);
                } else {
                    this._dataStore.remove(key);
                }
                contents = Shared.blockyReadFile(this._local, null, null);
                if (contents != null && (this._validator == null || this._validator.test(contents))) {
                    return contents;
                }
            }
            catch (IOException var9_9) {
                // empty catch block
            }
            if (tries >= this._maxTries || Shared.sleep(1000L)) continue;
            break;
        }
        return null;
    }

    private Map<String, String> parseField(String field) {
        return Pattern.compile(",").splitAsStream(field == null ? "" : field).map(String::trim).collect(HashMap::new, (m, s) -> {
            String[] as = s.split("=", 2);
            m.put(as[0], as.length == 2 ? as[1] : null);
        }, HashMap::putAll);
    }

    public byte[] read() {
        return Shared.blockyCall(() -> this.doRead(), null, null);
    }

    public CachedDownloader setCacheMinTTL(int cacheMinTTL) {
        this._cacheMinTTL = cacheMinTTL;
        return this;
    }

    public CachedDownloader setDataStore(Map<String, String> dataStore) {
        this._dataStore = dataStore;
        return this;
    }

    public CachedDownloader setErrorCodeHandler(Predicate<Integer> handler) {
        this._handler = handler;
        return this;
    }

    public CachedDownloader setLocal(File local) {
        this._local = local;
        return this;
    }

    public CachedDownloader setLocal(File dir, String filename) {
        this._local = new File(dir, filename);
        return this;
    }

    public CachedDownloader setLocal(File dir, String format, Object ... args) {
        this._local = new File(dir, String.format(format, args));
        return this;
    }

    public CachedDownloader setMaxTries(int maxTries) {
        this._maxTries = maxTries;
        return this;
    }

    public CachedDownloader setProxy(Proxy proxy) {
        this._proxy = proxy;
        return this;
    }

    public CachedDownloader setRemote(String remote) {
        try {
            this._remote = new URL(remote);
        }
        catch (MalformedURLException e) {
            this._remote = null;
        }
        return this;
    }

    public CachedDownloader setRemote(String format, Object ... args) {
        try {
            this._remote = new URL(String.format(format, args));
        }
        catch (MalformedURLException e) {
            this._remote = null;
        }
        return this;
    }

    public CachedDownloader setRemote(URL remote) {
        this._remote = remote;
        return this;
    }

    public CachedDownloader setValidator(Predicate<byte[]> validator) {
        this._validator = validator;
        return this;
    }
}

