/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.providers;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.UUID;
import java.util.function.Function;
import lain.mods.skins.api.interfaces.IPlayerProfile;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.api.interfaces.ISkinProvider;
import lain.mods.skins.impl.Shared;
import lain.mods.skins.impl.SkinData;
import lain.mods.skins.impl.fabric.MinecraftUtils;
import lain.mods.skins.providers.CachedDownloader;

public class CustomServerCachedCapeProvider
implements ISkinProvider {
    private File _dirN;
    private File _dirU;
    private Function<ByteBuffer, ByteBuffer> _filter;
    private String _host;

    public CustomServerCachedCapeProvider(Path workDir, String host) {
        this._dirN = new File(workDir.toFile(), "capes");
        this._dirN.mkdirs();
        this._dirU = new File(this._dirN, "uuid");
        this._dirU.mkdirs();
        this._host = host;
        for (File file : this._dirN.listFiles()) {
            if (!file.isFile()) continue;
            file.delete();
        }
        for (File file : this._dirU.listFiles()) {
            if (!file.isFile()) continue;
            file.delete();
        }
    }

    @Override
    public ISkin getSkin(IPlayerProfile profile) {
        SkinData skin = new SkinData();
        if (this._filter != null) {
            skin.setSkinFilter(this._filter);
        }
        Shared.pool.execute(() -> {
            byte[] data = null;
            UUID uuid = profile.getPlayerID();
            String name = profile.getPlayerName();
            if (!Shared.isOfflinePlayer(profile.getPlayerID(), profile.getPlayerName())) {
                data = CachedDownloader.create().setLocal(this._dirU, uuid.toString()).setRemote("%s/capes/%s", this._host, uuid).setDataStore(Shared.store).setProxy(MinecraftUtils.getProxy()).setValidator(SkinData::validateData).read();
            }
            if (data == null && !Shared.isBlank(name)) {
                data = CachedDownloader.create().setLocal(this._dirN, name).setRemote("%s/capes/%s", this._host, name).setDataStore(Shared.store).setProxy(MinecraftUtils.getProxy()).setValidator(SkinData::validateData).read();
            }
            if (data != null) {
                skin.put(data, "cape");
            }
        });
        return skin;
    }

    public CustomServerCachedCapeProvider withFilter(Function<ByteBuffer, ByteBuffer> filter) {
        this._filter = filter;
        return this;
    }
}

