/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.providers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import lain.mods.skins.api.interfaces.IPlayerProfile;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.api.interfaces.ISkinProvider;
import lain.mods.skins.impl.Shared;
import lain.mods.skins.impl.SkinData;
import lain.mods.skins.impl.fabric.MinecraftUtils;
import lain.mods.skins.providers.CachedDownloader;

public class MojangCachedSkinProvider
implements ISkinProvider {
    private File _dirN;
    private File _dirU;
    private Function<ByteBuffer, ByteBuffer> _filter;

    public MojangCachedSkinProvider(Path workDir) {
        this._dirN = new File(workDir.toFile(), "skins");
        this._dirN.mkdirs();
        this._dirU = new File(this._dirN, "uuid");
        this._dirU.mkdirs();
        for (File file : this._dirN.listFiles()) {
            if (!file.isFile()) continue;
            file.delete();
        }
        for (File file : this._dirU.listFiles()) {
            if (!file.isFile()) continue;
            file.delete();
        }
    }

    @Override
    public ISkin getSkin(IPlayerProfile profile) {
        SkinData skin = new SkinData();
        if (this._filter != null) {
            skin.setSkinFilter(this._filter);
        }
        Shared.pool.execute(() -> {
            Map textures;
            byte[] data = null;
            UUID uuid = profile.getPlayerID();
            if (!Shared.isOfflinePlayer(profile.getPlayerID(), profile.getPlayerName()) && (textures = MinecraftUtils.getSessionService().getTextures((GameProfile)profile.getOriginal(), false)) != null && textures.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                MinecraftProfileTexture tex = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN);
                data = CachedDownloader.create().setLocal(this._dirU, uuid.toString()).setRemote(tex.getUrl()).setDataStore(Shared.store).setProxy(MinecraftUtils.getProxy()).setValidator(SkinData::validateData).read();
                if (data != null) {
                    skin.put(data, "slim".equals(tex.getMetadata("model")) ? "slim" : "default");
                }
            }
        });
        return skin;
    }

    public MojangCachedSkinProvider withFilter(Function<ByteBuffer, ByteBuffer> filter) {
        this._filter = filter;
        return this;
    }
}

