/*
 * Decompiled with CFR 0.152.
 */
package notjoe.cereal.deserialization;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import notjoe.cereal.deserialization.LoadableState;
import notjoe.cereal.deserialization.PrimitiveDeserializer;
import notjoe.cereal.persistence.ReadInstruction;
import notjoe.cereal.persistence.WriteInstruction;
import notjoe.cereal.storage.BlockPosStorage;
import notjoe.cereal.storage.IdentifierStorage;
import notjoe.cereal.storage.ItemStackStorage;
import notjoe.cereal.util.Pair;
import org.apache.commons.lang3.reflect.FieldUtils;

public interface Deserializer {
    public static final ImmutableList<Deserializer> BUILTINS = ImmutableList.builder().add((Object)PrimitiveDeserializer.newInstance()).add((Object)ItemStackStorage.newInstance()).add((Object)BlockPosStorage.newInstance()).add((Object)IdentifierStorage.newInstance()).build();

    public static void loadStateOfSingleObject(Object object, class_2487 tag, ImmutableList<Deserializer> deserializers) {
        if (object instanceof LoadableState) {
            ((LoadableState)object).loadStateFromTag((class_2520)tag);
            return;
        }
        List fieldsToWrite = FieldUtils.getAllFieldsList(object.getClass()).stream().map(f -> Pair.of(f, WriteInstruction.getIdealWriteInstruction(f, object))).filter(p -> ((Optional)p.getRight()).isPresent()).map(p -> p.mapRight(Optional::get)).collect(Collectors.toList());
        for (Pair fieldAndWriter : fieldsToWrite) {
            Field workingField = (Field)fieldAndWriter.getLeft();
            WriteInstruction writer = (WriteInstruction)fieldAndWriter.getRight();
            if (!tag.method_10545(workingField.getName())) continue;
            class_2520 fieldValue = Objects.requireNonNull(tag.method_10580(workingField.getName()));
            Optional<Deserializer> bestDeserializer = deserializers.stream().filter(d -> d.canDeserialize(workingField.getType(), fieldValue)).findFirst();
            if (bestDeserializer.isPresent()) {
                writer.writeValue(Deserializer.deserializeSingleObject(workingField.getType(), fieldValue, deserializers));
                continue;
            }
            ReadInstruction reader = ReadInstruction.getIdealReadInstruction(workingField, object).orElseThrow(() -> new RuntimeException("Failed to read the value of field " + workingField.getName() + " to load its state."));
            if (fieldValue.method_10711() == 10) {
                Deserializer.loadStateOfSingleObject(reader.readAsObject(), (class_2487)fieldValue, deserializers);
                continue;
            }
            throw new RuntimeException("Failed to deserialize the value of field " + workingField.getName() + " as its tag wasn't a compound tag.");
        }
    }

    public static Object deserializeSingleObject(Class<?> desiredType, class_2520 tag, ImmutableList<Deserializer> deserializers) {
        Deserializer deserializer = deserializers.stream().filter(s -> s.canDeserialize(desiredType, tag)).findFirst().orElseThrow(() -> new RuntimeException("Couldn't find a deserializer for type " + desiredType.getSimpleName() + ". If it's not possible to implement NbtDeserializable, try explicitly specifying a Deserializer."));
        return deserializer.deserializeFromTag(desiredType, tag);
    }

    public boolean canDeserialize(Class<?> var1, class_2520 var2);

    public Object deserializeFromTag(Class<?> var1, class_2520 var2);
}

