/*
 * Decompiled with CFR 0.152.
 */
package notjoe.cereal.deserialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.function.Function;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2520;
import notjoe.cereal.deserialization.Deserializer;
import org.apache.commons.lang3.ClassUtils;

public class PrimitiveDeserializer
implements Deserializer {
    private static final ImmutableMap<Integer, Function<class_2520, Object>> TAG_DESERIALIZERS = ImmutableMap.builder().put((Object)1, t -> ((class_2481)t).method_10698()).put((Object)7, t -> ((class_2479)t).method_10521()).put((Object)6, t -> ((class_2489)t).method_10697()).put((Object)5, t -> Float.valueOf(((class_2494)t).method_10700())).put((Object)3, t -> ((class_2497)t).method_10701()).put((Object)11, t -> ((class_2495)t).method_10588()).put((Object)4, t -> ((class_2503)t).method_10699()).put((Object)12, t -> ((class_2501)t).method_10615()).put((Object)2, t -> ((class_2516)t).method_10696()).put((Object)8, class_2520::method_10714).build();
    private static final ImmutableMap<Integer, Class<?>> TAG_TYPES = ImmutableMap.builder().put((Object)1, Byte.class).put((Object)7, byte[].class).put((Object)6, Double.class).put((Object)5, Float.class).put((Object)3, Integer.class).put((Object)11, int[].class).put((Object)4, Long.class).put((Object)12, long[].class).put((Object)2, Short.class).put((Object)8, String.class).build();

    private PrimitiveDeserializer() {
    }

    public static PrimitiveDeserializer newInstance() {
        return new PrimitiveDeserializer();
    }

    @Override
    public boolean canDeserialize(Class<?> desiredType, class_2520 tag) {
        if (desiredType == null || tag == null) {
            return false;
        }
        byte tagType = tag.method_10711();
        Class wrappedType = ClassUtils.primitiveToWrapper(desiredType);
        return TAG_DESERIALIZERS.containsKey((Object)tagType) && TAG_TYPES.containsKey((Object)tagType) && (((Class)TAG_TYPES.get((Object)tagType)).equals(wrappedType) || tagType == 1 && wrappedType.equals(Boolean.class));
    }

    @Override
    public Object deserializeFromTag(Class<?> desiredType, class_2520 tag) {
        Preconditions.checkNotNull(desiredType, (Object)"attempted to deserialize to a null type");
        Preconditions.checkNotNull((Object)tag, (Object)"attempted to deserialize newInstance a null tag");
        Preconditions.checkState((boolean)this.canDeserialize(desiredType, tag), (Object)"attempted to deserialize a non-primitive NBT value with a primitive deserializer");
        Class wrappedType = ClassUtils.primitiveToWrapper(desiredType);
        if (tag.method_10711() == 1 && wrappedType.equals(Boolean.class)) {
            return ((class_2481)tag).method_10698() == 1;
        }
        return wrappedType.cast(((Function)TAG_DESERIALIZERS.get((Object)tag.method_10711())).apply(tag));
    }
}

