/*
 * Decompiled with CFR 0.152.
 */
package notjoe.cereal.persistence;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import notjoe.cereal.persistence.ReadInstruction;

public class MethodHandleReader
implements ReadInstruction {
    private final MethodHandle handle;

    private MethodHandleReader(MethodHandle handle) {
        this.handle = handle;
    }

    public static <T> MethodHandleReader fromField(MethodHandles.Lookup lookupStrategy, Field fieldToRead, T workingObject) {
        if (!fieldToRead.isAccessible()) {
            fieldToRead.setAccessible(true);
        }
        try {
            return new MethodHandleReader(lookupStrategy.unreflectGetter(fieldToRead).bindTo(workingObject));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to obtain a MethodHandle for reading field " + fieldToRead.getName() + ". Is any additional protection present?", e);
        }
    }

    public static <T> MethodHandleReader fromGetterMethod(MethodHandles.Lookup lookupStrategy, Method getterMethod, T workingObject) {
        if (!getterMethod.isAccessible()) {
            getterMethod.setAccessible(true);
        }
        try {
            return new MethodHandleReader(lookupStrategy.unreflect(getterMethod).bindTo(workingObject));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to obtain a MethodHandle for the getter " + getterMethod.getName() + ". Is any additional protection present?", e);
        }
    }

    @Override
    public Object readAsObject() {
        try {
            return this.handle.invoke();
        }
        catch (Throwable t) {
            throw new RuntimeException("An unexpected error occurred while reading a value from an object.", t);
        }
    }
}

