/*
 * Decompiled with CFR 0.152.
 */
package notjoe.cereal.persistence;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import notjoe.cereal.persistence.WriteInstruction;

public class MethodHandleWriter
implements WriteInstruction {
    private final MethodHandle handle;

    public static <T> MethodHandleWriter fromField(MethodHandles.Lookup lookupStrategy, Field fieldToWrite, T workingObject) {
        if (!fieldToWrite.isAccessible()) {
            fieldToWrite.setAccessible(true);
        }
        try {
            return new MethodHandleWriter(lookupStrategy.unreflectSetter(fieldToWrite).bindTo(workingObject));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to obtain a MethodHandle for reading field " + fieldToWrite.getName() + ". Is any additional protection present?", e);
        }
    }

    private MethodHandleWriter(MethodHandle handle) {
        this.handle = handle;
    }

    public static <T> MethodHandleWriter fromSetterMethod(MethodHandles.Lookup lookupStrategy, Method setterMethod, T workingObject) {
        if (!setterMethod.isAccessible()) {
            setterMethod.setAccessible(true);
        }
        try {
            return new MethodHandleWriter(lookupStrategy.unreflect(setterMethod).bindTo(workingObject));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to obtain a MethodHandle for the getter " + setterMethod.getName() + ". Is any additional protection present?", e);
        }
    }

    @Override
    public void writeValue(Object value) {
        try {
            this.handle.invoke(value);
        }
        catch (Throwable t) {
            throw new RuntimeException("An unexpected error occurred while reading a value from an object.", t);
        }
    }
}

