/*
 * Decompiled with CFR 0.152.
 */
package notjoe.cereal.persistence;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import notjoe.cereal.persistence.MethodHandleReader;
import notjoe.cereal.persistence.Persistent;

public interface ReadInstruction {
    public static Optional<ReadInstruction> getIdealReadInstruction(Field fieldToRead, Object workingObject) {
        if (fieldToRead.isAnnotationPresent(Persistent.class)) {
            return ReadInstruction.getPersistentReadInstruction(fieldToRead.getAnnotation(Persistent.class), fieldToRead, workingObject);
        }
        return Optional.empty();
    }

    public static Optional<ReadInstruction> getPersistentReadInstruction(Persistent persistenceInfo, Field fieldToRead, Object workingObject) {
        String getterName = persistenceInfo.getter();
        if (getterName.isEmpty()) {
            return Optional.of(MethodHandleReader.fromField(MethodHandles.lookup(), fieldToRead, workingObject));
        }
        try {
            Method getterMethod = workingObject.getClass().getMethod(getterName, new Class[0]);
            return Optional.of(MethodHandleReader.fromGetterMethod(MethodHandles.lookup(), getterMethod, workingObject));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find a method by the name of " + getterName + " in class " + workingObject.getClass().getSimpleName() + ". Does the method exist?");
        }
    }

    public Object readAsObject();
}

