/*
 * Decompiled with CFR 0.152.
 */
package notjoe.cereal.persistence;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import notjoe.cereal.persistence.MethodHandleWriter;
import notjoe.cereal.persistence.Persistent;

public interface WriteInstruction {
    public static Optional<WriteInstruction> getIdealWriteInstruction(Field fieldToWrite, Object workingObject) {
        if (Modifier.isFinal(fieldToWrite.getModifiers())) {
            return Optional.empty();
        }
        if (fieldToWrite.isAnnotationPresent(Persistent.class)) {
            return WriteInstruction.getPersistentWriteInstruction(fieldToWrite.getAnnotation(Persistent.class), fieldToWrite, workingObject);
        }
        return Optional.empty();
    }

    public static Optional<WriteInstruction> getPersistentWriteInstruction(Persistent persistenceInfo, Field fieldToWrite, Object workingObject) {
        String setterName = persistenceInfo.setter();
        if (setterName.isEmpty()) {
            return Optional.of(MethodHandleWriter.fromField(MethodHandles.lookup(), fieldToWrite, workingObject));
        }
        try {
            Method setterMethod = workingObject.getClass().getMethod(setterName, new Class[0]);
            return Optional.of(MethodHandleWriter.fromSetterMethod(MethodHandles.lookup(), setterMethod, workingObject));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find a method by the name of " + setterName + " in class " + workingObject.getClass().getSimpleName() + ". Does the method exist?");
        }
    }

    public void writeValue(Object var1);
}

