/*
 * Decompiled with CFR 0.152.
 */
package notjoe.cereal.serialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.function.Function;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import notjoe.cereal.serialization.Serializer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;

public class PrimitiveSerializer
implements Serializer {
    private static final ImmutableMap<Class<?>, Function<Object, class_2520>> TAG_SERIALIZERS = ImmutableMap.builder().put(Boolean.class, b -> new class_2481((byte)((Boolean)b != false ? 1 : 0))).put(Byte.class, b -> new class_2481(((Byte)b).byteValue())).put(byte[].class, ba -> new class_2479((byte[])ba)).put(Byte[].class, ba -> new class_2479(ArrayUtils.toPrimitive((Byte[])((Byte[])ba)))).put(Double.class, d -> new class_2489(((Double)d).doubleValue())).put(Float.class, f -> new class_2494(((Float)f).floatValue())).put(Integer.class, i -> new class_2497(((Integer)i).intValue())).put(int[].class, ia -> new class_2495((int[])ia)).put(Integer[].class, ia -> new class_2495(ArrayUtils.toPrimitive((Integer[])((Integer[])ia)))).put(Long.class, l -> new class_2503(((Long)l).longValue())).put(long[].class, la -> new class_2501((long[])la)).put(Long[].class, la -> new class_2501(ArrayUtils.toPrimitive((Long[])((Long[])la)))).put(Short.class, s -> new class_2516(((Short)s).shortValue())).put(String.class, s -> new class_2519((String)s)).build();

    private PrimitiveSerializer() {
    }

    public static PrimitiveSerializer newInstance() {
        return new PrimitiveSerializer();
    }

    @Override
    public boolean canSerialize(Object o) {
        return o != null && TAG_SERIALIZERS.containsKey((Object)ClassUtils.primitiveToWrapper(o.getClass()));
    }

    @Override
    public class_2520 serializeToTag(Object o) {
        Preconditions.checkNotNull((Object)o, (Object)"attempted to serializeAllPossibleFields a null value to a tag");
        Preconditions.checkState((boolean)this.canSerialize(o), (Object)"attempted to serializeAllPossibleFields a non-primitive value with a primitive serializer");
        return (class_2520)((Function)TAG_SERIALIZERS.get(o.getClass())).apply(o);
    }
}

