/*
 * Decompiled with CFR 0.152.
 */
package notjoe.cereal.serialization;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import notjoe.cereal.persistence.ReadInstruction;
import notjoe.cereal.serialization.PrimitiveSerializer;
import notjoe.cereal.serialization.RecursiveSerializer;
import notjoe.cereal.storage.BlockPosStorage;
import notjoe.cereal.storage.IdentifierStorage;
import notjoe.cereal.storage.ItemStackStorage;
import notjoe.cereal.util.CompoundTagBuilder;
import notjoe.cereal.util.Pair;
import org.apache.commons.lang3.reflect.FieldUtils;

public interface Serializer {
    public static final ImmutableList<Serializer> BUILTINS = ImmutableList.builder().add((Object)PrimitiveSerializer.newInstance()).add((Object)ItemStackStorage.newInstance()).add((Object)BlockPosStorage.newInstance()).add((Object)IdentifierStorage.newInstance()).build();
    public static final ImmutableList<Serializer> BUILTINS_WITH_RECURSION = ImmutableList.builder().addAll(BUILTINS).add((Object)RecursiveSerializer.withBaseCases(BUILTINS)).build();

    public static <T> class_2487 serializeAllPossibleFields(T object, List<Serializer> serializers) {
        return FieldUtils.getAllFieldsList(object.getClass()).stream().map(f -> Pair.of(f.getName(), ReadInstruction.getIdealReadInstruction(f, object))).filter(p -> ((Optional)p.getRight()).isPresent()).map(p -> p.mapRight(Optional::get)).map(p -> p.mapRight(ReadInstruction::readAsObject)).map(p -> p.mapRight(o -> Serializer.serializeSingleObject(o, serializers))).reduce(CompoundTagBuilder.newCompoundTag(), (b, p) -> p.combine(b::withTag), (n, o) -> n).build();
    }

    public static <T> class_2520 serializeSingleObject(T object, List<Serializer> serializers) {
        Serializer serializer = serializers.stream().filter(s -> s.canSerialize(object)).findFirst().orElseThrow(() -> new RuntimeException("Couldn't find a serializer for type " + object.getClass().getSimpleName() + ". If it's not possible to implement NbtSerializable, try explicitly specifying a Serializer."));
        return serializer.serializeToTag(object);
    }

    public boolean canSerialize(Object var1);

    public class_2520 serializeToTag(Object var1);
}

