/*
 * Decompiled with CFR 0.152.
 */
package notjoe.cereal.util;

import java.util.function.BiFunction;
import java.util.function.Function;

public class Pair<A, B> {
    private final A left;
    private final B right;

    public static <A, B> Pair<A, B> of(A left, B right) {
        return new Pair<A, B>(left, right);
    }

    private Pair(A left, B right) {
        this.left = left;
        this.right = right;
    }

    public A getLeft() {
        return this.left;
    }

    public B getRight() {
        return this.right;
    }

    public <C> Pair<C, B> mapLeft(Function<A, C> mapper) {
        return new Pair<C, B>(mapper.apply(this.left), this.right);
    }

    public <C> Pair<A, C> mapRight(Function<B, C> mapper) {
        return new Pair<A, C>(this.left, mapper.apply(this.right));
    }

    public <C> C combine(BiFunction<A, B, C> combiner) {
        return combiner.apply(this.left, this.right);
    }
}

