/*
 * Decompiled with CFR 0.152.
 */
package therealfarfetchd.minicfg;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import therealfarfetchd.minicfg.MiniCfgParser;
import therealfarfetchd.minicfg.MiniCfgProcessor;

public abstract class MiniCfg {
    private Path disk;
    private Supplier<InputStream> defaultFile;
    private MiniCfgProcessor processor = new MiniCfgProcessor();

    protected final void disk(String path) {
        this.disk(Paths.get(path, new String[0]));
    }

    protected final void disk(Path path) {
        this.disk = path;
    }

    protected final void extract(Supplier<InputStream> op) {
        this.defaultFile = op;
    }

    protected void addInt(String prop, Consumer<Integer> ... ops) {
        this.addCustom(prop, this::parseInt, ops);
    }

    protected void addBoolean(String prop, Consumer<Boolean> ... ops) {
        this.addCustom(prop, this::parseBoolean, ops);
    }

    protected void addFlag(String prop, Runnable ... ops) {
        this.add(prop, arr -> {
            for (Runnable op : ops) {
                op.run();
            }
        });
    }

    protected void addColor(String prop, Consumer<Color> op) {
        this.add(prop, arr -> {
            int red = ((String[])arr).length < 1 ? 0 : this.parseInt(arr[0]);
            int green = ((String[])arr).length < 2 ? 0 : this.parseInt(arr[1]);
            int blue = ((String[])arr).length < 3 ? 0 : this.parseInt(arr[2]);
            int alpha = ((String[])arr).length < 4 ? 255 : this.parseInt(arr[3]);
            op.accept(new Color(red, green, blue, alpha));
        });
    }

    protected void addIdentifier(String prop, Consumer<class_2960> ... ops) {
        this.addCustom(prop, s -> s == null ? new class_2960("") : new class_2960(s), ops);
    }

    protected void addString(String prop, Consumer<String> ... ops) {
        this.add(prop, arr -> {
            for (int i = 0; i < ops.length; ++i) {
                Consumer op = ops[i];
                if (((String[])arr).length < i) {
                    op.accept("");
                    continue;
                }
                op.accept(arr[i]);
            }
        });
    }

    protected <T> void addCustom(String prop, Function<String, T> mapper, Consumer<T> ... ops) {
        this.add(prop, arr -> {
            for (int i = 0; i < ops.length; ++i) {
                Consumer op = ops[i];
                if (((String[])arr).length < i) {
                    op.accept(mapper.apply(null));
                    continue;
                }
                op.accept(mapper.apply(arr[i]));
            }
        });
    }

    protected void add(String prop, Consumer<String[]> op) {
        this.processor.addProperty(prop, op);
    }

    protected final void parse() {
        if (this.disk == null) {
            return;
        }
        if (!Files.exists(this.disk, new LinkOption[0])) {
            try {
                Files.createDirectories(this.disk.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            if (this.defaultFile == null) {
                return;
            }
            try (InputStream is = this.defaultFile.get();){
                Files.copy(is, this.disk, new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            List<String> lines = Files.readAllLines(this.disk);
            MiniCfgParser.INSTANCE.parse(this.processor, lines);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private int parseInt(String s) {
        if (s == null) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private boolean parseBoolean(String s) {
        if (s == null) {
            return false;
        }
        return "true".equals(s) || "yes".equals(s) || this.parseInt(s) != 0;
    }
}

