/*
 * Decompiled with CFR 0.152.
 */
package therealfarfetchd.minicfg;

import java.util.ArrayList;
import java.util.List;
import therealfarfetchd.minicfg.MiniCfgProcessor;

public class MiniCfgParser {
    public static final MiniCfgParser INSTANCE = new MiniCfgParser();

    private MiniCfgParser() {
    }

    public void parse(MiniCfgProcessor processor, List<String> lines) {
        for (String line : lines) {
            String[] tokens;
            if ((line = this.stripComment(line).trim()).isEmpty() || (tokens = this.tokenize(line)).length == 0) continue;
            String[] args = new String[tokens.length - 1];
            System.arraycopy(tokens, 1, args, 0, args.length);
            processor.call(tokens[0], args);
        }
    }

    private String stripComment(String in) {
        int c = in.indexOf(59);
        return c == -1 ? in : in.substring(0, c);
    }

    private String[] tokenize(String in) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : in.split("\\s")) {
            if (s.isEmpty()) continue;
            result.add(s);
        }
        return result.toArray(new String[0]);
    }
}

