/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import io.netty.buffer.ByteBuf;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IEntityStyle;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementEntityRender;
import mcjty.theoneprobe.apiimpl.styles.EntityStyle;
import mcjty.theoneprobe.network.NetworkTools;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class ElementEntity
implements IElement {
    private final class_2960 entityIdentifier;
    private final Integer playerID;
    private final class_2487 entityNBT;
    private final IEntityStyle style;

    public ElementEntity(class_2960 entityIdentifier, IEntityStyle style) {
        this.entityIdentifier = entityIdentifier;
        this.entityNBT = null;
        this.style = style;
        this.playerID = null;
    }

    public ElementEntity(class_1297 entity, IEntityStyle style) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.entityNBT = null;
            this.playerID = player.method_5628();
            this.entityIdentifier = null;
        } else {
            this.entityNBT = new class_2487();
            entity.method_5786(this.entityNBT);
            this.playerID = null;
            this.entityIdentifier = class_2378.field_11145.method_10221((Object)entity.method_5864());
        }
        this.style = style;
    }

    public ElementEntity(ByteBuf buf) {
        String id = NetworkTools.readString(buf);
        this.entityIdentifier = id == null ? null : new class_2960(id);
        this.style = new EntityStyle().width(buf.readInt()).height(buf.readInt()).scale(buf.readFloat());
        this.entityNBT = buf.readBoolean() ? NetworkTools.readNBT(buf) : null;
        this.playerID = buf.readBoolean() ? Integer.valueOf(buf.readInt()) : null;
    }

    @Override
    public void render(int x, int y) {
        if (this.playerID != null) {
            ElementEntityRender.renderPlayer(this.playerID, this.style, x, y);
        } else {
            ElementEntityRender.render(this.entityIdentifier, this.entityNBT, this.style, x, y);
        }
    }

    @Override
    public int getWidth() {
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        NetworkTools.writeString(buf, this.entityIdentifier == null ? null : this.entityIdentifier.toString());
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        buf.writeFloat(this.style.getScale());
        if (this.entityNBT != null) {
            buf.writeBoolean(true);
            NetworkTools.writeNBT(buf, this.entityNBT);
        } else {
            buf.writeBoolean(false);
        }
        if (this.playerID != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.playerID.intValue());
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_ENTITY;
    }
}

