/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;

public class ChestInfoTools {
    static void showChestInfo(ProbeMode mode, IProbeInfo probeInfo, class_1937 world, class_2338 pos, IProbeConfig config) {
        ArrayList<class_1799> stacks = null;
        IProbeConfig.ConfigMode chestMode = config.getShowChestContents();
        if (!(chestMode != IProbeConfig.ConfigMode.EXTENDED || Config.showSmallChestContentsWithoutSneaking <= 0 && Config.getInventoriesToShow().isEmpty())) {
            int slots;
            if (Config.getInventoriesToShow().contains(class_2378.field_11146.method_10221((Object)world.method_8320(pos).method_11614()))) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            } else if (Config.showSmallChestContentsWithoutSneaking > 0 && (slots = ChestInfoTools.getChestContents(world, pos, stacks = new ArrayList())) <= Config.showSmallChestContentsWithoutSneaking) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            }
        } else if (chestMode == IProbeConfig.ConfigMode.NORMAL && !Config.getInventoriesToNotShow().isEmpty() && Config.getInventoriesToNotShow().contains(class_2378.field_11146.method_10221((Object)world.method_8320(pos).method_11614()))) {
            chestMode = IProbeConfig.ConfigMode.EXTENDED;
        }
        if (Tools.show(mode, chestMode)) {
            if (stacks == null) {
                stacks = new ArrayList<class_1799>();
                ChestInfoTools.getChestContents(world, pos, stacks);
            }
            if (!stacks.isEmpty()) {
                boolean showDetailed = Tools.show(mode, config.getShowChestContentsDetailed()) && stacks.size() <= Config.showItemDetailThresshold;
                ChestInfoTools.showChestContents(probeInfo, world, pos, stacks, showDetailed);
            }
        }
    }

    public static boolean canItemStacksStack(@Nonnull class_1799 a, @Nonnull class_1799 b) {
        if (a.method_7960() || !a.method_7962(b) || a.method_7985() != b.method_7985()) {
            return false;
        }
        return !a.method_7985() || a.method_7969().equals((Object)b.method_7969());
    }

    private static void addItemStack(List<class_1799> stacks, Set<class_1792> foundItems, @Nonnull class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        if (foundItems != null && foundItems.contains(stack.method_7909())) {
            for (class_1799 s : stacks) {
                if (!ChestInfoTools.canItemStacksStack(s, stack)) continue;
                s.method_7933(stack.method_7947());
                return;
            }
        }
        stacks.add(stack.method_7972());
        if (foundItems != null) {
            foundItems.add(stack.method_7909());
        }
    }

    private static void showChestContents(IProbeInfo probeInfo, class_1937 world, class_2338 pos, List<class_1799> stacks, boolean detailed) {
        IProbeInfo vertical = null;
        IProbeInfo horizontal = null;
        int rows = 0;
        int idx = 0;
        vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Config.chestContentsBorderColor).spacing(0));
        if (detailed) {
            for (class_1799 stackInSlot : stacks) {
                horizontal = vertical.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER));
                horizontal.item(stackInSlot, new ItemStyle().width(16).height(16)).text((Object)((Object)TextStyleClass.INFO) + stackInSlot.method_7964().method_10863());
            }
        } else {
            for (class_1799 stackInSlot : stacks) {
                if (idx % 10 == 0) {
                    horizontal = vertical.horizontal(new LayoutStyle().spacing(0));
                    if (++rows > 4) break;
                }
                horizontal.item(stackInSlot);
                ++idx;
            }
        }
    }

    private static int getChestContents(class_1937 world, class_2338 pos, List<class_1799> stacks) {
        class_2586 te = world.method_8321(pos);
        HashSet<class_1792> foundItems = Config.compactEqualStacks ? new HashSet<class_1792>() : null;
        int maxSlots = 0;
        try {
            if (te instanceof class_1263) {
                class_1263 inventory = (class_1263)te;
                maxSlots = inventory.method_5439();
                for (int i = 0; i < maxSlots; ++i) {
                    ChestInfoTools.addItemStack(stacks, foundItems, inventory.method_5438(i));
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Getting the contents of a " + class_2378.field_11146.method_10221((Object)world.method_8320(pos).method_11614()) + " (" + te.getClass().getName() + ")", e);
        }
        return maxSlots;
    }
}

