/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.UUID;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IEntityDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1312;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1493;
import net.minecraft.class_1498;
import net.minecraft.class_1533;
import net.minecraft.class_1612;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3532;

public class DefaultProbeInfoEntityProvider
implements IProbeInfoEntityProvider {
    private static DecimalFormat dfCommas = new DecimalFormat("##.#");

    @Override
    public String getID() {
        return "theoneprobe:entity.default";
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, class_1657 player, class_1937 world, class_1297 entity, IProbeHitEntityData data) {
        class_1493 wolf;
        IProbeConfig config = Config.getRealConfig();
        boolean handled = false;
        for (IEntityDisplayOverride override : TheOneProbe.theOneProbeImp.getEntityOverrides()) {
            if (!override.overrideStandardInfo(mode, probeInfo, player, world, entity, data)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, config);
        }
        if (entity instanceof class_1309) {
            Collection effects;
            int age;
            class_1309 livingBase = (class_1309)entity;
            if (Tools.show(mode, config.getShowMobHealth())) {
                int health = (int)livingBase.method_6032();
                int maxHealth = (int)livingBase.method_6063();
                int armor = livingBase.method_6096();
                probeInfo.progress(health, maxHealth, probeInfo.defaultProgressStyle().lifeBar(true).showText(false).width(150).height(10));
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Health: " + (Object)((Object)TextStyleClass.INFOIMP) + health + " / " + maxHealth);
                }
                if (armor > 0) {
                    probeInfo.progress(armor, armor, probeInfo.defaultProgressStyle().armorBar(true).showText(false).width(80).height(10));
                }
            }
            if (Tools.show(mode, config.getShowMobGrowth()) && entity instanceof class_1296 && (age = ((class_1296)entity).method_5618()) < 0) {
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Growing time: " + age * -1 / 20 + "s");
            }
            if (Tools.show(mode, config.getShowMobPotionEffects()) && !(effects = livingBase.method_6026()).isEmpty()) {
                IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(-1));
                float durationFactor = 1.0f;
                for (class_1293 effect : effects) {
                    String s1 = "{*" + effect.method_5586() + "*}";
                    class_1291 potion = effect.method_5579();
                    if (effect.method_5578() > 0) {
                        s1 = s1 + " " + "{*" + "potion.potency." + effect.method_5578() + "*}";
                    }
                    if (effect.method_5584() > 20) {
                        s1 = s1 + " (" + DefaultProbeInfoEntityProvider.getPotionDurationString(effect, durationFactor) + ")";
                    }
                    if (potion.method_5570()) {
                        vertical.text((Object)((Object)TextStyleClass.ERROR) + s1);
                        continue;
                    }
                    vertical.text((Object)((Object)TextStyleClass.OK) + s1);
                }
            }
        } else if (entity instanceof class_1533) {
            class_1533 itemFrame = (class_1533)entity;
            class_1799 stack = itemFrame.method_6940();
            if (!stack.method_7960()) {
                probeInfo.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER)).item(stack, new ItemStyle().width(16).height(16)).text((Object)((Object)TextStyleClass.INFO) + stack.method_7964().method_10863());
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Rotation: " + (Object)((Object)TextStyleClass.INFO) + itemFrame.method_6934());
                }
            } else {
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Empty");
            }
        }
        if (Tools.show(mode, config.getAnimalOwnerSetting())) {
            UUID ownerId = null;
            if (entity instanceof class_1312) {
                ownerId = ((class_1312)entity).method_6139();
            } else if (entity instanceof class_1498) {
                ownerId = ((class_1498)entity).method_6768();
            }
            if (ownerId != null) {
                probeInfo.text((Object)((Object)TextStyleClass.WARNING) + "Unknown owner");
            } else if (entity instanceof class_1321) {
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Tameable");
            }
        }
        if (Tools.show(mode, config.getHorseStatSetting()) && entity instanceof class_1498) {
            double jumpStrength = ((class_1498)entity).method_6771();
            double jumpHeight = -0.1817584952 * jumpStrength * jumpStrength * jumpStrength + 3.689713992 * jumpStrength * jumpStrength + 2.128599134 * jumpStrength - 0.343930367;
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Jump height: " + (Object)((Object)TextStyleClass.INFO) + dfCommas.format(jumpHeight));
            class_1324 iattributeinstance = ((class_1498)entity).method_5996(class_1612.field_7357);
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Speed: " + (Object)((Object)TextStyleClass.INFO) + dfCommas.format(iattributeinstance.method_6194()));
        }
        if (entity instanceof class_1493 && Config.showCollarColor && (wolf = (class_1493)entity).method_6181()) {
            class_1767 collarColor = wolf.method_6713();
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Collar: " + (Object)((Object)TextStyleClass.INFO) + collarColor.method_7792());
        }
    }

    public static String getPotionDurationString(class_1293 effect, float factor) {
        if (effect.method_5584() == Short.MAX_VALUE) {
            return "**:**";
        }
        int i = class_3532.method_15375((float)((float)effect.method_5584() * factor));
        return DefaultProbeInfoEntityProvider.ticksToElapsedTime(i);
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public static void showStandardInfo(ProbeMode mode, IProbeInfo probeInfo, class_1297 entity, IProbeConfig config) {
        String modid = Tools.getModName(entity);
        if (Tools.show(mode, config.getShowModName())) {
            probeInfo.horizontal().entity(entity).vertical().text((Object)((Object)TextStyleClass.NAME) + entity.method_5476().method_10863()).text((Object)((Object)TextStyleClass.MODNAME) + modid);
        } else {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).entity(entity).text((Object)((Object)TextStyleClass.NAME) + entity.method_5476().method_10863());
        }
    }
}

