/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.Collections;
import mcjty.lib.api.power.IBigPower;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeConfig;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.providers.ChestInfoTools;
import mcjty.theoneprobe.apiimpl.providers.HarvestInfoTools;
import mcjty.theoneprobe.compat.RedstoneFluxTools;
import mcjty.theoneprobe.compat.TeslaTools;
import mcjty.theoneprobe.config.Config;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1917;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2260;
import net.minecraft.class_2286;
import net.minecraft.class_2338;
import net.minecraft.class_2384;
import net.minecraft.class_2401;
import net.minecraft.class_2404;
import net.minecraft.class_2457;
import net.minecraft.class_2462;
import net.minecraft.class_2496;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2747;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;

public class DefaultProbeInfoProvider
implements IProbeInfoProvider {
    @Override
    public String getID() {
        return "theoneprobe:default";
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, class_1657 player, class_1937 world, class_2680 blockState, IProbeHitData data) {
        class_2248 block = blockState.method_11614();
        class_2338 pos = data.getPos();
        IProbeConfig config = Config.getRealConfig();
        boolean handled = false;
        for (IBlockDisplayOverride override : TheOneProbe.theOneProbeImp.getBlockOverrides()) {
            if (!override.overrideStandardInfo(mode, probeInfo, player, world, blockState, data)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            DefaultProbeInfoProvider.showStandardBlockInfo(config, mode, probeInfo, blockState, block, world, pos, player, data);
        }
        if (Tools.show(mode, config.getShowCropPercentage())) {
            this.showGrowthLevel(probeInfo, blockState);
        }
        boolean showHarvestLevel = Tools.show(mode, config.getShowHarvestLevel());
        boolean showHarvested = Tools.show(mode, config.getShowCanBeHarvested());
        if (showHarvested && showHarvestLevel) {
            HarvestInfoTools.showHarvestInfo(probeInfo, world, pos, block, blockState, player);
        } else if (showHarvestLevel) {
            HarvestInfoTools.showHarvestLevel(probeInfo, blockState, block);
        } else if (showHarvested) {
            HarvestInfoTools.showCanBeHarvested(probeInfo, world, pos, block, player);
        }
        if (Tools.show(mode, config.getShowRedstone())) {
            this.showRedstonePower(probeInfo, world, blockState, data, block, Tools.show(mode, config.getShowLeverSetting()));
        }
        if (Tools.show(mode, config.getShowLeverSetting())) {
            this.showLeverSetting(probeInfo, world, blockState, data, block);
        }
        ChestInfoTools.showChestInfo(mode, probeInfo, world, pos, config);
        if (config.getRFMode() > 0) {
            this.showRF(probeInfo, world, pos);
        }
        if (Tools.show(mode, config.getShowTankSetting()) && config.getTankMode() > 0) {
            this.showTankInfo(probeInfo, world, pos);
        }
        if (Tools.show(mode, config.getShowBrewStandSetting())) {
            this.showBrewingStandInfo(probeInfo, world, data, block);
        }
        if (Tools.show(mode, config.getShowMobSpawnerSetting())) {
            this.showMobSpawnerInfo(probeInfo, world, data, block);
        }
    }

    private void showBrewingStandInfo(IProbeInfo probeInfo, class_1937 world, IProbeHitData data, class_2248 block) {
        if (block instanceof class_2260) {
            class_2586 class_25862 = world.method_8321(data.getPos());
        }
    }

    private void showMobSpawnerInfo(IProbeInfo probeInfo, class_1937 world, IProbeHitData data, class_2248 block) {
        class_2586 te;
        if (block instanceof class_2496 && (te = world.method_8321(data.getPos())) instanceof class_2636) {
            class_1917 class_19172 = ((class_2636)te).method_11390();
        }
    }

    private void showRedstonePower(IProbeInfo probeInfo, class_1937 world, class_2680 blockState, IProbeHitData data, class_2248 block, boolean showLever) {
        if (showLever && block instanceof class_2401) {
            return;
        }
        int redstonePower = block instanceof class_2457 ? ((Integer)blockState.method_11654((class_2769)class_2457.field_11432)).intValue() : world.method_8499(data.getPos(), data.getSideHit().method_10153());
        if (redstonePower > 0) {
            probeInfo.horizontal().item(new class_1799((class_1935)class_1802.field_8725), probeInfo.defaultItemStyle().width(14).height(14)).text((Object)((Object)TextStyleClass.LABEL) + "Power: " + (Object)((Object)TextStyleClass.INFO) + redstonePower);
        }
    }

    private void showLeverSetting(IProbeInfo probeInfo, class_1937 world, class_2680 blockState, IProbeHitData data, class_2248 block) {
        if (block instanceof class_2401) {
            Boolean powered = (Boolean)blockState.method_11654((class_2769)class_2401.field_11265);
            probeInfo.horizontal().item(new class_1799((class_1935)class_1802.field_8725), probeInfo.defaultItemStyle().width(14).height(14)).text((Object)((Object)TextStyleClass.LABEL) + "State: " + (Object)((Object)TextStyleClass.INFO) + (powered != false ? "On" : "Off"));
        } else if (block instanceof class_2286) {
            class_2747 mode = (class_2747)blockState.method_11654((class_2769)class_2286.field_10789);
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Mode: " + (Object)((Object)TextStyleClass.INFO) + mode.name());
        } else if (block instanceof class_2462) {
            Boolean locked = (Boolean)blockState.method_11654((class_2769)class_2462.field_11452);
            Integer delay = (Integer)blockState.method_11654((class_2769)class_2462.field_11451);
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Delay: " + (Object)((Object)TextStyleClass.INFO) + delay + " ticks");
            if (locked.booleanValue()) {
                probeInfo.text((Object)((Object)TextStyleClass.INFO) + "Locked");
            }
        }
    }

    private void showTankInfo(IProbeInfo probeInfo, class_1937 world, class_2338 pos) {
    }

    private void showRF(IProbeInfo probeInfo, class_1937 world, class_2338 pos) {
        ProbeConfig config = Config.getDefaultConfig();
        class_2586 te = world.method_8321(pos);
        if (TheOneProbe.tesla && TeslaTools.isEnergyHandler(te)) {
            long energy = TeslaTools.getEnergy(te);
            long maxEnergy = TeslaTools.getMaxEnergy(te);
            this.addRFInfo(probeInfo, config, energy, maxEnergy);
        } else if (te instanceof IBigPower) {
            long energy = ((IBigPower)te).getStoredPower();
            long maxEnergy = ((IBigPower)te).getCapacity();
            this.addRFInfo(probeInfo, config, energy, maxEnergy);
        } else if (TheOneProbe.redstoneflux && RedstoneFluxTools.isEnergyHandler(te)) {
            int energy = RedstoneFluxTools.getEnergy(te);
            int maxEnergy = RedstoneFluxTools.getMaxEnergy(te);
            this.addRFInfo(probeInfo, config, energy, maxEnergy);
        }
    }

    private void addRFInfo(IProbeInfo probeInfo, ProbeConfig config, long energy, long maxEnergy) {
        if (config.getRFMode() == 1) {
            probeInfo.progress(energy, maxEnergy, probeInfo.defaultProgressStyle().suffix("RF").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(Config.rfFormat));
        } else {
            probeInfo.text((Object)((Object)TextStyleClass.PROGRESS) + "RF: " + ElementProgress.format(energy, Config.rfFormat, "RF"));
        }
    }

    private void showGrowthLevel(IProbeInfo probeInfo, class_2680 blockState) {
        for (class_2769 property : blockState.method_11569()) {
            if (!"age".equals(property.method_11899())) continue;
            if (property.method_11902() == Integer.class) {
                int maxAge;
                class_2769 integerProperty = property;
                int age = (Integer)blockState.method_11654(integerProperty);
                if (age == (maxAge = ((Integer)Collections.max(integerProperty.method_11898())).intValue())) {
                    probeInfo.text((Object)((Object)TextStyleClass.OK) + "Fully grown");
                } else {
                    probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Growth: " + (Object)((Object)TextStyleClass.WARNING) + age * 100 / maxAge + "%");
                }
            }
            return;
        }
    }

    public static void showStandardBlockInfo(IProbeConfig config, ProbeMode mode, IProbeInfo probeInfo, class_2680 blockState, class_2248 block, class_1937 world, class_2338 pos, class_1657 player, IProbeHitData data) {
        class_3610 fluidState;
        String modid = Tools.getModName(block);
        class_1799 pickBlock = data.getPickBlock();
        if (block instanceof class_2384 && mode != ProbeMode.DEBUG && !Tools.show(mode, config.getShowSilverfish())) {
            block = ((class_2384)block).method_10271();
            pickBlock = new class_1799((class_1935)block, 1);
        }
        if (block instanceof class_2404 && (fluidState = world.method_8316(pos)) != null) {
            class_3611 fluid = fluidState.method_15772();
            class_1792 bucketItem = fluid.method_15774();
            IProbeInfo horizontal = probeInfo.horizontal();
            if (bucketItem != class_1802.field_8162) {
                horizontal.item(new class_1799((class_1935)bucketItem));
            }
            horizontal.vertical().text((Object)((Object)TextStyleClass.NAME) + "{*" + block.method_9539() + "*}").text((Object)((Object)TextStyleClass.MODNAME) + modid);
            return;
        }
        if (!pickBlock.method_7960()) {
            if (Tools.show(mode, config.getShowModName())) {
                probeInfo.horizontal().item(pickBlock).vertical().itemLabel(pickBlock).text((Object)((Object)TextStyleClass.MODNAME) + modid);
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(pickBlock).itemLabel(pickBlock);
            }
        } else if (Tools.show(mode, config.getShowModName())) {
            probeInfo.vertical().text((Object)((Object)TextStyleClass.NAME) + DefaultProbeInfoProvider.getBlockUnlocalizedName(block)).text((Object)((Object)TextStyleClass.MODNAME) + modid);
        } else {
            probeInfo.vertical().text((Object)((Object)TextStyleClass.NAME) + DefaultProbeInfoProvider.getBlockUnlocalizedName(block));
        }
    }

    private static String getBlockUnlocalizedName(class_2248 block) {
        return "{*" + block.method_9539() + ".name" + "*}";
    }
}

