/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import net.fabricmc.fabric.api.tag.FabricItemTags;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;

public class HarvestInfoTools {
    private static final class_2960 ICONS = new class_2960("theoneprobe", "textures/gui/icons.png");
    private static String[] harvestLevels = new String[]{"stone", "iron", "diamond", "obsidian", "cobalt"};
    private static final Map<String, class_1799> testTools = new HashMap<String, class_1799>();
    private static LoadingCache<class_2680, MiningInfo> miningInfoCache;

    private static int checkHarvestability(Collection<class_1792> itemsToCheck, class_2680 state) {
        int smallestNeededLevel = 100000;
        for (class_1792 item : itemsToCheck) {
            class_1832 type;
            int level;
            class_1799 s = new class_1799((class_1935)item);
            if (!state.method_11620().method_15805() && !s.method_7951(state) || !(item instanceof class_1831) || (level = (type = ((class_1831)item).method_8022()).method_8024()) >= smallestNeededLevel) continue;
            smallestNeededLevel = level;
        }
        return smallestNeededLevel >= 100000 ? -1 : smallestNeededLevel;
    }

    private static MiningInfo fetchMiningInfo(class_2680 blockState) {
        String harvestTool = null;
        int level = -1;
        level = HarvestInfoTools.checkHarvestability(FabricItemTags.AXES.method_15138(), blockState);
        if (level != -1) {
            harvestTool = "axe";
        } else {
            level = HarvestInfoTools.checkHarvestability(FabricItemTags.PICKAXES.method_15138(), blockState);
            if (level != -1) {
                harvestTool = "pickaxe";
            } else {
                level = HarvestInfoTools.checkHarvestability(FabricItemTags.SHOVELS.method_15138(), blockState);
                if (level != -1) {
                    harvestTool = "shovel";
                } else {
                    level = HarvestInfoTools.checkHarvestability(FabricItemTags.HOES.method_15138(), blockState);
                    if (level != -1) {
                        harvestTool = "hoe";
                    } else {
                        level = HarvestInfoTools.checkHarvestability(FabricItemTags.SWORDS.method_15138(), blockState);
                        if (level != -1) {
                            harvestTool = "sword";
                        }
                    }
                }
            }
        }
        if (harvestTool == null) {
            return new MiningInfo(null, -1);
        }
        return new MiningInfo(harvestTool, level);
    }

    static void showHarvestLevel(IProbeInfo probeInfo, class_2680 blockState, class_2248 block) {
        MiningInfo info = (MiningInfo)miningInfoCache.getUnchecked((Object)blockState);
        if (info.tool != null) {
            int harvestLevel = info.level;
            String harvestName = harvestLevel >= harvestLevels.length ? Integer.toString(harvestLevel) : (harvestLevel < 0 ? Integer.toString(harvestLevel) : harvestLevels[harvestLevel]);
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Tool: " + (Object)((Object)TextStyleClass.INFO) + info.tool + " (level " + harvestName + ")");
        }
    }

    private static boolean canHarvestBlock(@Nonnull class_2248 block, @Nonnull class_1657 player, @Nonnull class_1937 world, @Nonnull class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (state.method_11620().method_15805()) {
            return true;
        }
        class_1799 stack = player.method_6047();
        return stack.method_7951(state);
    }

    static void showCanBeHarvested(IProbeInfo probeInfo, class_1937 world, class_2338 pos, class_2248 block, class_1657 player) {
        if (ModItems.isProbeInHand(player.method_6047())) {
            return;
        }
        boolean harvestable = HarvestInfoTools.canHarvestBlock(block, player, world, pos);
        if (harvestable) {
            probeInfo.text((Object)((Object)TextStyleClass.OK) + "Harvestable");
        } else {
            probeInfo.text((Object)((Object)TextStyleClass.WARNING) + "Not harvestable");
        }
    }

    static void showHarvestInfo(IProbeInfo probeInfo, class_1937 world, class_2338 pos, class_2248 block, class_2680 blockState, class_1657 player) {
        boolean v;
        float blockHardness;
        boolean harvestable = HarvestInfoTools.canHarvestBlock(block, player, world, pos);
        MiningInfo info = (MiningInfo)miningInfoCache.getUnchecked((Object)blockState);
        String harvestTool = info.tool;
        String harvestName = null;
        if (harvestTool == null && (blockHardness = blockState.method_11579((class_1922)world, pos)) > 0.0f) {
            for (Map.Entry<String, class_1799> testToolEntry : testTools.entrySet()) {
                class_1799 testTool = testToolEntry.getValue();
                if (testTool == null || !(testTool.method_7909() instanceof class_1831)) continue;
                class_1831 toolItem = (class_1831)testTool.method_7909();
                if (!(testTool.method_7924(blockState) >= toolItem.method_8022().method_8027())) continue;
                harvestTool = testToolEntry.getKey();
                break;
            }
        }
        if (harvestTool != null) {
            int harvestLevel = info.level;
            if (harvestLevel >= 0 && harvestLevel < harvestLevels.length) {
                harvestName = harvestLevels[harvestLevel];
            }
            harvestTool = StringUtils.capitalize((String)harvestTool);
        }
        int offs = (v = Config.harvestStyleVanilla) ? 16 : 0;
        int dim = v ? 13 : 16;
        ILayoutStyle alignment = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        IIconStyle iconStyle = probeInfo.defaultIconStyle().width(v ? 18 : 20).height(v ? 14 : 16).textureWidth(32).textureHeight(32);
        IProbeInfo horizontal = probeInfo.horizontal(alignment);
        if (harvestable) {
            horizontal.icon(ICONS, 0, offs, dim, dim, iconStyle).text((Object)((Object)TextStyleClass.OK) + (harvestTool != null ? harvestTool : "No tool"));
        } else if (harvestName == null || harvestName.isEmpty()) {
            horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text((Object)((Object)TextStyleClass.WARNING) + (harvestTool != null ? harvestTool : "No tool"));
        } else {
            horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text((Object)((Object)TextStyleClass.WARNING) + (harvestTool != null ? harvestTool : "No tool") + " (level " + harvestName + ")");
        }
    }

    static {
        testTools.put("shovel", new class_1799((class_1935)class_1802.field_8876));
        testTools.put("axe", new class_1799((class_1935)class_1802.field_8406));
        testTools.put("pickaxe", new class_1799((class_1935)class_1802.field_8647));
        miningInfoCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(state -> HarvestInfoTools.fetchMiningInfo(state)));
    }

    private static class MiningInfo {
        private final String tool;
        private final int level;

        public MiningInfo(String tool, int level) {
            this.tool = tool;
            this.level = level;
        }
    }
}

