/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.theoneprobe.api.IOverlayStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeConfig;
import mcjty.theoneprobe.apiimpl.styles.DefaultOverlayStyle;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;

public class Config {
    public static String CATEGORY_THEONEPROBE = "theoneprobe";
    public static String CATEGORY_PROVIDERS = "providers";
    public static String CATEGORY_CLIENT = "client";
    public static final int PROBE_NOTNEEDED = 0;
    public static final int PROBE_NEEDED = 1;
    public static final int PROBE_NEEDEDHARD = 2;
    public static final int PROBE_NEEDEDFOREXTENDED = 3;
    public static int needsProbe = 3;
    public static boolean extendedInMain = false;
    public static NumberFormat rfFormat = NumberFormat.COMPACT;
    public static NumberFormat tankFormat = NumberFormat.COMPACT;
    public static int timeout = 300;
    public static int waitingForServerTimeout = 2000;
    public static int maxPacketToServer = 20000;
    public static boolean supportBaubles = true;
    public static boolean spawnNote = true;
    public static int showSmallChestContentsWithoutSneaking = 0;
    public static int showItemDetailThresshold = 4;
    public static String[] showContentsWithoutSneaking = new String[]{"storagedrawers:basicDrawers", "storagedrawersextra:extra_drawers"};
    public static String[] dontShowContentsUnlessSneaking = new String[0];
    public static String[] dontSendNBT = new String[0];
    private static Set<class_2960> inventoriesToShow = null;
    private static Set<class_2960> inventoriesToNotShow = null;
    private static Set<class_2960> dontSendNBTSet = null;
    public static float probeDistance = 6.0f;
    public static boolean showLiquids = true;
    public static boolean isVisible = true;
    public static boolean compactEqualStacks = true;
    public static boolean holdKeyToMakeVisible = false;
    public static boolean showDebugInfo = true;
    private static int leftX = 5;
    private static int topY = 5;
    private static int rightX = -1;
    private static int bottomY = -1;
    public static int showBreakProgress = 1;
    public static boolean harvestStyleVanilla = true;
    public static int chestContentsBorderColor = -16750951;
    private static int boxBorderColor = -6710887;
    private static int boxFillColor = 1426089625;
    private static int boxThickness = 2;
    private static int boxOffset = 0;
    public static float tooltipScale = 1.0f;
    public static int rfbarFilledColor = -2293760;
    public static int rfbarAlternateFilledColor = -12386304;
    public static int rfbarBorderColor = -11184811;
    public static int tankbarFilledColor = -16776995;
    public static int tankbarAlternateFilledColor = -16777149;
    public static int tankbarBorderColor = -11184811;
    public static Map<TextStyleClass, String> defaultTextStyleClasses = new HashMap<TextStyleClass, String>();
    public static Map<TextStyleClass, String> textStyleClasses;
    public static int loggingThrowableTimeout;
    public static boolean showCollarColor;
    private static IOverlayStyle defaultOverlayStyle;
    private static ProbeConfig defaultConfig;
    private static IProbeConfig realConfig;

    public static ProbeConfig getDefaultConfig() {
        return defaultConfig;
    }

    public static void setRealConfig(IProbeConfig config) {
        realConfig = config;
    }

    public static IProbeConfig getRealConfig() {
        return realConfig;
    }

    public static void setupStyleConfig() {
        DummyConfiguration cfg = new DummyConfiguration();
        leftX = cfg.getInt("boxLeftX", CATEGORY_CLIENT, leftX, -1, 10000, "The distance to the left side of the screen. Use -1 if you don't want to set this");
        rightX = cfg.getInt("boxRightX", CATEGORY_CLIENT, rightX, -1, 10000, "The distance to the right side of the screen. Use -1 if you don't want to set this");
        topY = cfg.getInt("boxTopY", CATEGORY_CLIENT, topY, -1, 10000, "The distance to the top side of the screen. Use -1 if you don't want to set this");
        bottomY = cfg.getInt("boxBottomY", CATEGORY_CLIENT, bottomY, -1, 10000, "The distance to the bottom side of the screen. Use -1 if you don't want to set this");
        boxBorderColor = Config.parseColor(cfg.getString("boxBorderColor", CATEGORY_CLIENT, Integer.toHexString(boxBorderColor), "Color of the border of the box (0 to disable)"));
        boxFillColor = Config.parseColor(cfg.getString("boxFillColor", CATEGORY_CLIENT, Integer.toHexString(boxFillColor), "Color of the box (0 to disable)"));
        boxThickness = cfg.getInt("boxThickness", CATEGORY_CLIENT, boxThickness, 0, 20, "Thickness of the border of the box (0 to disable)");
        boxOffset = cfg.getInt("boxOffset", CATEGORY_CLIENT, boxOffset, 0, 20, "How much the border should be offset (i.e. to create an 'outer' border)");
        showLiquids = cfg.getBoolean("showLiquids", CATEGORY_CLIENT, showLiquids, "If true show liquid information when the probe hits liquid first");
        isVisible = cfg.getBoolean("isVisible", CATEGORY_CLIENT, isVisible, "Toggle default probe visibility (client can override)");
        holdKeyToMakeVisible = cfg.getBoolean("holdKeyToMakeVisible", CATEGORY_CLIENT, holdKeyToMakeVisible, "If true then the probe hotkey must be held down to show the tooltip");
        compactEqualStacks = cfg.getBoolean("compactEqualStacks", CATEGORY_CLIENT, compactEqualStacks, "If true equal stacks will be compacted in the chest contents overlay");
        tooltipScale = cfg.getFloat("tooltipScale", CATEGORY_CLIENT, tooltipScale, 0.4f, 5.0f, "The scale of the tooltips, 1 is default, 2 is smaller");
        chestContentsBorderColor = Config.parseColor(cfg.getString("chestContentsBorderColor", CATEGORY_CLIENT, Integer.toHexString(chestContentsBorderColor), "Color of the border of the chest contents box (0 to disable)"));
        showBreakProgress = cfg.getInt("showBreakProgress", CATEGORY_CLIENT, showBreakProgress, 0, 2, "0 means don't show break progress, 1 is show as bar, 2 is show as text");
        harvestStyleVanilla = cfg.getBoolean("harvestStyleVanilla", CATEGORY_CLIENT, harvestStyleVanilla, "true means shows harvestability with vanilla style icons");
        HashMap<TextStyleClass, String> newformat = new HashMap<TextStyleClass, String>();
        for (TextStyleClass styleClass : textStyleClasses.keySet()) {
            String style = cfg.getString("textStyle" + styleClass.getReadableName(), CATEGORY_CLIENT, textStyleClasses.get((Object)styleClass), "Text style. Use a comma delimited list with colors like: 'red', 'green', 'blue', ... or style codes like 'underline', 'bold', 'italic', 'strikethrough', ...");
            newformat.put(styleClass, style);
        }
        textStyleClasses = newformat;
        extendedInMain = cfg.getBoolean("extendedInMain", CATEGORY_CLIENT, extendedInMain, "If true the probe will automatically show extended information if it is in your main hand (so not required to sneak)");
    }

    public static void setTextStyle(TextStyleClass styleClass, String style) {
    }

    public static void setExtendedInMain(boolean extendedInMain) {
    }

    public static void setLiquids(boolean liquids) {
    }

    public static void setVisible(boolean visible) {
    }

    public static void setPos(int leftx, int topy, int rightx, int bottomy) {
    }

    public static void setScale(float scale) {
    }

    public static void setBoxStyle(int thickness, int borderColor, int fillcolor, int offset) {
    }

    private static String configToTextFormat(String input) {
        String[] splitted;
        if ("context".equals(input)) {
            return "context";
        }
        StringBuilder builder = new StringBuilder();
        for (String s : splitted = StringUtils.split((String)input, (char)',')) {
            class_124 format = class_124.method_533((String)s);
            if (format == null) continue;
            builder.append(format.toString());
        }
        return builder.toString();
    }

    public static String getTextStyle(TextStyleClass styleClass) {
        if (textStyleClasses.containsKey((Object)styleClass)) {
            return Config.configToTextFormat(textStyleClasses.get((Object)styleClass));
        }
        return "";
    }

    private static int parseColor(String col) {
        try {
            return (int)Long.parseLong(col, 16);
        }
        catch (NumberFormatException e) {
            System.out.println("Config.parseColor");
            return 0;
        }
    }

    public static void updateDefaultOverlayStyle() {
        defaultOverlayStyle = new DefaultOverlayStyle().borderThickness(boxThickness).borderColor(boxBorderColor).boxColor(boxFillColor).borderOffset(boxOffset).location(leftX, rightX, topY, bottomY);
    }

    public static IOverlayStyle getDefaultOverlayStyle() {
        if (defaultOverlayStyle == null) {
            Config.updateDefaultOverlayStyle();
        }
        return defaultOverlayStyle;
    }

    public static Set<class_2960> getInventoriesToShow() {
        if (inventoriesToShow == null) {
            inventoriesToShow = new HashSet<class_2960>();
            for (String s : showContentsWithoutSneaking) {
                inventoriesToShow.add(new class_2960(s));
            }
        }
        return inventoriesToShow;
    }

    public static Set<class_2960> getInventoriesToNotShow() {
        if (inventoriesToNotShow == null) {
            inventoriesToNotShow = new HashSet<class_2960>();
            for (String s : dontShowContentsUnlessSneaking) {
                inventoriesToNotShow.add(new class_2960(s));
            }
        }
        return inventoriesToNotShow;
    }

    public static Set<class_2960> getDontSendNBTSet() {
        if (dontSendNBTSet == null) {
            dontSendNBTSet = new HashSet<class_2960>();
            for (String s : dontSendNBT) {
                dontSendNBTSet.add(new class_2960(s));
            }
        }
        return dontSendNBTSet;
    }

    static {
        defaultTextStyleClasses.put(TextStyleClass.NAME, "white");
        defaultTextStyleClasses.put(TextStyleClass.MODNAME, "blue,italic");
        defaultTextStyleClasses.put(TextStyleClass.ERROR, "red,bold");
        defaultTextStyleClasses.put(TextStyleClass.WARNING, "yellow");
        defaultTextStyleClasses.put(TextStyleClass.OK, "green");
        defaultTextStyleClasses.put(TextStyleClass.INFO, "white");
        defaultTextStyleClasses.put(TextStyleClass.INFOIMP, "blue");
        defaultTextStyleClasses.put(TextStyleClass.OBSOLETE, "gray,strikethrough");
        defaultTextStyleClasses.put(TextStyleClass.LABEL, "gray");
        defaultTextStyleClasses.put(TextStyleClass.PROGRESS, "white");
        textStyleClasses = new HashMap<TextStyleClass, String>(defaultTextStyleClasses);
        loggingThrowableTimeout = 20000;
        showCollarColor = true;
        defaultConfig = new ProbeConfig();
    }

    private static class DummyConfiguration {
        private DummyConfiguration() {
        }

        public int getInt(String name, String category, int def, int min, int max, String desc) {
            return def;
        }

        public float getFloat(String name, String category, float def, float min, float max, String desc) {
            return def;
        }

        public String getString(String name, String category, String def, String desc) {
            return def;
        }

        public boolean getBoolean(String name, String category, boolean def, String desc) {
            return def;
        }
    }
}

