/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public class NetworkTools {
    public static class_2487 readNBT(ByteBuf dataIn) {
        class_2540 buf = new class_2540(dataIn);
        return buf.method_10798();
    }

    public static void writeNBT(ByteBuf dataOut, class_2487 nbt) {
        class_2540 buf = new class_2540(dataOut);
        try {
            buf.method_10794(nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class_1799 readItemStack(ByteBuf dataIn) {
        class_2540 buf = new class_2540(dataIn);
        class_2487 nbt = buf.method_10798();
        class_1799 stack = class_1799.method_7915((class_2487)nbt);
        stack.method_7939(buf.readInt());
        return stack;
    }

    public static void writeItemStack(ByteBuf dataOut, class_1799 itemStack) {
        class_2540 buf = new class_2540(dataOut);
        class_2487 nbt = new class_2487();
        itemStack.method_7953(nbt);
        try {
            buf.method_10794(nbt);
            buf.writeInt(itemStack.method_7947());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readString(ByteBuf dataIn) {
        int s = dataIn.readInt();
        if (s == -1) {
            return null;
        }
        if (s == 0) {
            return "";
        }
        byte[] dst = new byte[s];
        dataIn.readBytes(dst);
        return new String(dst);
    }

    public static void writeString(ByteBuf dataOut, String str) {
        if (str == null) {
            dataOut.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes();
        dataOut.writeInt(bytes.length);
        if (bytes.length > 0) {
            dataOut.writeBytes(bytes);
        }
    }

    public static String readStringUTF8(ByteBuf dataIn) {
        int s = dataIn.readInt();
        if (s == -1) {
            return null;
        }
        if (s == 0) {
            return "";
        }
        byte[] dst = new byte[s];
        dataIn.readBytes(dst);
        return new String(dst, StandardCharsets.UTF_8);
    }

    public static void writeStringUTF8(ByteBuf dataOut, String str) {
        if (str == null) {
            dataOut.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        dataOut.writeInt(bytes.length);
        if (bytes.length > 0) {
            dataOut.writeBytes(bytes);
        }
    }

    public static class_2338 readPos(ByteBuf dataIn) {
        return new class_2338(dataIn.readInt(), dataIn.readInt(), dataIn.readInt());
    }

    public static void writePos(ByteBuf dataOut, class_2338 pos) {
        dataOut.writeInt(pos.method_10263());
        dataOut.writeInt(pos.method_10264());
        dataOut.writeInt(pos.method_10260());
    }

    public static <T extends Enum<T>> void writeEnum(ByteBuf buf, T value, T nullValue) {
        if (value == null) {
            buf.writeInt(nullValue.ordinal());
        } else {
            buf.writeInt(value.ordinal());
        }
    }

    public static <T extends Enum<T>> T readEnum(ByteBuf buf, T[] values) {
        return values[buf.readInt()];
    }

    public static <T extends Enum<T>> void writeEnumCollection(ByteBuf buf, Collection<T> collection) {
        buf.writeInt(collection.size());
        for (Enum type : collection) {
            buf.writeInt(type.ordinal());
        }
    }

    public static <T extends Enum<T>> void readEnumCollection(ByteBuf buf, Collection<T> collection, T[] values) {
        collection.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            collection.add(values[buf.readInt()]);
        }
    }

    public static void writeFloat(ByteBuf buf, Float f) {
        if (f != null) {
            buf.writeBoolean(true);
            buf.writeFloat(f.floatValue());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static Float readFloat(ByteBuf buf) {
        if (buf.readBoolean()) {
            return Float.valueOf(buf.readFloat());
        }
        return null;
    }

    public static void writeItemStack(class_2540 to, class_1799 stack) {
        class_2540 pb = new class_2540((ByteBuf)to);
        pb.method_10793(stack);
    }

    public static class_1799 readItemStack(class_2540 from) {
        class_2540 pb = new class_2540((ByteBuf)from);
        return pb.method_10819();
    }
}

