/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitEntityData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.network.IPacket;
import mcjty.theoneprobe.network.MessageHandler;
import mcjty.theoneprobe.network.NetworkInit;
import mcjty.theoneprobe.network.PacketReturnEntityInfo;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.fabricmc.fabric.api.network.PacketContext;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PacketGetEntityInfo
implements IPacket {
    public static final class_2960 GET_ENTITY_INFO = new class_2960("theoneprobe", "get_entity_info");
    private int dim;
    private UUID uuid;
    private ProbeMode mode;
    private class_243 hitVec;

    @Override
    public class_2960 getId() {
        return GET_ENTITY_INFO;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.mode = ProbeMode.values()[buf.readByte()];
        if (buf.readBoolean()) {
            this.hitVec = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeByte(this.mode.ordinal());
        if (this.hitVec == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeDouble(this.hitVec.field_1352);
            buf.writeDouble(this.hitVec.field_1351);
            buf.writeDouble(this.hitVec.field_1350);
        }
    }

    public PacketGetEntityInfo() {
    }

    public PacketGetEntityInfo(int dim, ProbeMode mode, class_239 mouseOver, class_1297 entity) {
        this.dim = dim;
        this.uuid = entity.method_5667();
        this.mode = mode;
        this.hitVec = mouseOver.method_17784();
    }

    private static ProbeInfo getProbeInfo(class_1657 player, ProbeMode mode, class_1937 world, class_1297 entity, class_243 hitVec) {
        if (Config.needsProbe == 3) {
            if (!ModItems.hasAProbeSomewhere(player) && mode == ProbeMode.EXTENDED) {
                mode = ProbeMode.NORMAL;
            }
        } else if (Config.needsProbe == 2 && !ModItems.hasAProbeSomewhere(player)) {
            return null;
        }
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ProbeHitEntityData data = new ProbeHitEntityData(hitVec);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        List<IProbeConfigProvider> configProviders = TheOneProbe.theOneProbeImp.getConfigProviders();
        for (IProbeConfigProvider configProvider : configProviders) {
            configProvider.getProbeConfig(probeConfig, player, world, entity, data);
        }
        Config.setRealConfig(probeConfig);
        List<IProbeInfoEntityProvider> entityProviders = TheOneProbe.theOneProbeImp.getEntityProviders();
        for (IProbeInfoEntityProvider provider : entityProviders) {
            try {
                provider.addProbeEntityInfo(mode, probeInfo, player, world, entity, data);
            }
            catch (Throwable e) {
                ThrowableIdentity.registerThrowable(e);
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Error: " + (Object)((Object)TextStyleClass.ERROR) + provider.getID());
            }
        }
        return probeInfo;
    }

    public static class Handler
    extends MessageHandler<PacketGetEntityInfo> {
        @Override
        protected PacketGetEntityInfo createPacket() {
            return new PacketGetEntityInfo();
        }

        @Override
        void handle(PacketContext context, PacketGetEntityInfo message) {
            class_1297 entity;
            class_3218 world = context.getPlayer().method_5770().method_8503().method_3847(class_2874.method_12490((int)message.dim));
            if (world != null && (entity = world.method_14190(message.uuid)) != null) {
                ProbeInfo probeInfo = PacketGetEntityInfo.getProbeInfo(context.getPlayer(), message.mode, (class_1937)world, entity, message.hitVec);
                NetworkInit.sendToClient(new PacketReturnEntityInfo(message.uuid, probeInfo), (class_3222)context.getPlayer());
            }
        }
    }
}

