/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.network.IPacket;
import mcjty.theoneprobe.network.MessageHandler;
import mcjty.theoneprobe.network.NetworkInit;
import mcjty.theoneprobe.network.NetworkTools;
import mcjty.theoneprobe.network.PacketReturnInfo;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.fabricmc.fabric.api.network.PacketContext;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public class PacketGetInfo
implements IPacket {
    public static final class_2960 GET_INFO = new class_2960("theoneprobe", "get_info");
    private int dim;
    private class_2338 pos;
    private ProbeMode mode;
    private class_2350 sideHit;
    private class_243 hitVec;
    private class_1799 pickBlock;

    @Override
    public class_2960 getId() {
        return GET_INFO;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.pos = new class_2338(buf.readInt(), buf.readInt(), buf.readInt());
        this.mode = ProbeMode.values()[buf.readByte()];
        byte sideByte = buf.readByte();
        this.sideHit = sideByte == 127 ? null : class_2350.values()[sideByte];
        if (buf.readBoolean()) {
            this.hitVec = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
        this.pickBlock = NetworkTools.readItemStack(buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.pos.method_10263());
        buf.writeInt(this.pos.method_10264());
        buf.writeInt(this.pos.method_10260());
        buf.writeByte(this.mode.ordinal());
        buf.writeByte(this.sideHit == null ? 127 : this.sideHit.ordinal());
        if (this.hitVec == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeDouble(this.hitVec.field_1352);
            buf.writeDouble(this.hitVec.field_1351);
            buf.writeDouble(this.hitVec.field_1350);
        }
        ByteBuf buffer = Unpooled.buffer();
        NetworkTools.writeItemStack(buffer, this.pickBlock);
        if (buffer.writerIndex() <= Config.maxPacketToServer) {
            buf.writeBytes(buffer);
        } else {
            class_1799 copy = new class_1799((class_1935)this.pickBlock.method_7909(), this.pickBlock.method_7947());
            NetworkTools.writeItemStack(buf, copy);
        }
    }

    public PacketGetInfo() {
    }

    public PacketGetInfo(int dim, class_2338 pos, ProbeMode mode, class_239 mouseOver, class_1799 pickBlock) {
        this.dim = dim;
        this.pos = pos;
        this.mode = mode;
        this.sideHit = mouseOver.method_17783() == class_239.class_240.field_1332 ? ((class_3965)mouseOver).method_17780() : null;
        this.hitVec = mouseOver.method_17784();
        this.pickBlock = pickBlock;
    }

    private static ProbeInfo getProbeInfo(class_1657 player, ProbeMode mode, class_1937 world, class_2338 blockPos, class_2350 sideHit, class_243 hitVec, class_1799 pickBlock) {
        if (Config.needsProbe == 3) {
            if (!ModItems.hasAProbeSomewhere(player) && mode == ProbeMode.EXTENDED) {
                mode = ProbeMode.NORMAL;
            }
        } else if (Config.needsProbe == 2 && !ModItems.hasAProbeSomewhere(player)) {
            return null;
        }
        class_2680 state = world.method_8320(blockPos);
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ProbeHitData data = new ProbeHitData(blockPos, hitVec, sideHit, pickBlock);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        List<IProbeConfigProvider> configProviders = TheOneProbe.theOneProbeImp.getConfigProviders();
        for (IProbeConfigProvider configProvider : configProviders) {
            configProvider.getProbeConfig(probeConfig, player, world, state, data);
        }
        Config.setRealConfig(probeConfig);
        List<IProbeInfoProvider> providers = TheOneProbe.theOneProbeImp.getProviders();
        for (IProbeInfoProvider provider : providers) {
            try {
                provider.addProbeInfo(mode, probeInfo, player, world, state, data);
            }
            catch (Throwable e) {
                ThrowableIdentity.registerThrowable(e);
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Error: " + (Object)((Object)TextStyleClass.ERROR) + provider.getID());
            }
        }
        return probeInfo;
    }

    public static class Handler
    extends MessageHandler<PacketGetInfo> {
        @Override
        protected PacketGetInfo createPacket() {
            return new PacketGetInfo();
        }

        @Override
        void handle(PacketContext context, PacketGetInfo message) {
            class_3218 world = context.getPlayer().method_5770().method_8503().method_3847(class_2874.method_12490((int)message.dim));
            if (world != null) {
                ProbeInfo probeInfo = PacketGetInfo.getProbeInfo(context.getPlayer(), message.mode, (class_1937)world, message.pos, message.sideHit, message.hitVec, message.pickBlock);
                NetworkInit.sendToClient(new PacketReturnInfo(message.dim, message.pos, probeInfo), (class_3222)context.getPlayer());
            }
        }
    }
}

