/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.rendering;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IOverlayStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitData;
import mcjty.theoneprobe.apiimpl.ProbeHitEntityData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.elements.ElementText;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoEntityProvider;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.network.NetworkInit;
import mcjty.theoneprobe.network.PacketGetEntityInfo;
import mcjty.theoneprobe.network.PacketGetInfo;
import mcjty.theoneprobe.network.ThrowableIdentity;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_746;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayRenderer {
    private static Map<Pair<Integer, class_2338>, Pair<Long, ProbeInfo>> cachedInfo = new HashMap<Pair<Integer, class_2338>, Pair<Long, ProbeInfo>>();
    private static Map<UUID, Pair<Long, ProbeInfo>> cachedEntityInfo = new HashMap<UUID, Pair<Long, ProbeInfo>>();
    private static long lastCleanupTime = 0L;
    private static Pair<Long, ProbeInfo> lastPair;
    private static long lastPairTime;
    private static long lastRenderedTime;

    public static void registerProbeInfo(int dim, class_2338 pos, ProbeInfo probeInfo) {
        if (probeInfo == null) {
            return;
        }
        long time = System.currentTimeMillis();
        cachedInfo.put((Pair<Integer, class_2338>)Pair.of((Object)dim, (Object)pos), (Pair<Long, ProbeInfo>)Pair.of((Object)time, (Object)probeInfo));
    }

    public static void registerProbeInfo(UUID uuid, ProbeInfo probeInfo) {
        if (probeInfo == null) {
            return;
        }
        long time = System.currentTimeMillis();
        cachedEntityInfo.put(uuid, (Pair<Long, ProbeInfo>)Pair.of((Object)time, (Object)probeInfo));
    }

    public static void renderHUD(ProbeMode mode, float partialTicks) {
        float dist = Config.probeDistance;
        class_239 mouseOver = class_310.method_1551().field_1765;
        if (mouseOver != null && mouseOver.method_17783() == class_239.class_240.field_1331) {
            GlStateManager.pushMatrix();
            double scale = Config.tooltipScale;
            double sw = class_310.method_1551().field_1704.method_4486();
            double sh = class_310.method_1551().field_1704.method_4502();
            OverlayRenderer.setupOverlayRendering(sw * scale, sh * scale);
            OverlayRenderer.renderHUDEntity(mode, mouseOver, sw * scale, sh * scale);
            OverlayRenderer.setupOverlayRendering(sw, sh);
            GlStateManager.popMatrix();
            OverlayRenderer.checkCleanup();
            return;
        }
        class_746 entity = class_310.method_1551().field_1724;
        class_243 start = entity.method_5836(partialTicks);
        class_243 vec31 = entity.method_5828(partialTicks);
        class_243 end = start.method_1031(vec31.field_1352 * (double)dist, vec31.field_1351 * (double)dist, vec31.field_1350 * (double)dist);
        mouseOver = entity.method_5770().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)entity));
        if (mouseOver == null) {
            return;
        }
        if (mouseOver.method_17783() == class_239.class_240.field_1332) {
            GlStateManager.pushMatrix();
            double scale = Config.tooltipScale;
            double sw = class_310.method_1551().field_1704.method_4486();
            double sh = class_310.method_1551().field_1704.method_4502();
            OverlayRenderer.setupOverlayRendering(sw * scale, sh * scale);
            OverlayRenderer.renderHUDBlock(mode, mouseOver, sw * scale, sh * scale);
            OverlayRenderer.setupOverlayRendering(sw, sh);
            GlStateManager.popMatrix();
        }
        OverlayRenderer.checkCleanup();
    }

    public static void setupOverlayRendering(double sw, double sh) {
        GlStateManager.clear((int)256, (boolean)false);
        GlStateManager.matrixMode((int)5889);
        GlStateManager.loadIdentity();
        GlStateManager.ortho((double)0.0, (double)sw, (double)sh, (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.matrixMode((int)5888);
        GlStateManager.loadIdentity();
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    private static void checkCleanup() {
        long time = System.currentTimeMillis();
        if (time > lastCleanupTime + 5000L) {
            OverlayRenderer.cleanupCachedBlocks(time);
            OverlayRenderer.cleanupCachedEntities(time);
            lastCleanupTime = time;
        }
    }

    private static void renderHUDEntity(ProbeMode mode, class_239 mouseOver, double sw, double sh) {
        if (mouseOver.method_17783() != class_239.class_240.field_1331) {
            return;
        }
        class_3966 hitResult = (class_3966)mouseOver;
        class_1297 entity = hitResult.method_17782();
        if (entity == null) {
            return;
        }
        UUID uuid = entity.method_5667();
        class_746 player = class_310.method_1551().field_1724;
        long time = System.currentTimeMillis();
        Pair<Long, ProbeInfo> cacheEntry = cachedEntityInfo.get(uuid);
        if (cacheEntry == null || cacheEntry.getValue() == null) {
            if (cacheEntry == null || time >= (Long)cacheEntry.getLeft()) {
                cachedEntityInfo.put(uuid, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), null));
                OverlayRenderer.requestEntityInfo(mode, mouseOver, entity, player);
            }
            if (lastPair != null && time < lastPairTime + (long)Config.timeout) {
                OverlayRenderer.renderElements((ProbeInfo)lastPair.getRight(), Config.getDefaultOverlayStyle(), sw, sh, null);
                lastRenderedTime = time;
            } else if (Config.waitingForServerTimeout > 0 && lastRenderedTime != -1L && time > lastRenderedTime + (long)Config.waitingForServerTimeout) {
                ProbeInfo info = OverlayRenderer.getWaitingEntityInfo(mode, (class_3966)mouseOver, entity, player);
                OverlayRenderer.registerProbeInfo(uuid, info);
                lastPair = Pair.of((Object)time, (Object)info);
                lastPairTime = time;
                OverlayRenderer.renderElements((ProbeInfo)lastPair.getRight(), Config.getDefaultOverlayStyle(), sw, sh, null);
                lastRenderedTime = time;
            }
        } else {
            if (time > (Long)cacheEntry.getLeft() + (long)Config.timeout) {
                cachedEntityInfo.put(uuid, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), (Object)cacheEntry.getRight()));
                OverlayRenderer.requestEntityInfo(mode, mouseOver, entity, player);
            }
            OverlayRenderer.renderElements((ProbeInfo)cacheEntry.getRight(), Config.getDefaultOverlayStyle(), sw, sh, null);
            lastRenderedTime = time;
            lastPair = cacheEntry;
            lastPairTime = time;
        }
    }

    private static void requestEntityInfo(ProbeMode mode, class_239 mouseOver, class_1297 entity, class_746 player) {
        NetworkInit.sendToServer(new PacketGetEntityInfo(player.method_5770().field_9247.method_12460().method_12484(), mode, mouseOver, entity));
    }

    private static void renderHUDBlock(ProbeMode mode, class_239 mouseOver, double sw, double sh) {
        int dimension;
        Pair key;
        Pair<Long, ProbeInfo> cacheEntry;
        float damage;
        if (mouseOver.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_3965 blockResult = (class_3965)mouseOver;
        class_2338 blockPos = blockResult.method_17777();
        if (blockPos == null) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player.method_5770().method_8623(blockPos)) {
            return;
        }
        long time = System.currentTimeMillis();
        IElement damageElement = null;
        if (Config.showBreakProgress > 0 && (damage = 0.0f) > 0.0f) {
            damageElement = Config.showBreakProgress == 2 ? new ElementText("" + class_124.field_1061 + "Progress " + (int)(damage * 100.0f) + "%") : new ElementProgress((long)(damage * 100.0f), 100L, new ProgressStyle().prefix("Progress ").suffix("%").width(85).borderColor(0).filledColor(0).filledColor(-6750208).alternateFilledColor(-11206656));
        }
        if ((cacheEntry = cachedInfo.get(key = Pair.of((Object)(dimension = player.method_5770().field_9247.method_12460().method_12484()), (Object)blockPos))) == null || cacheEntry.getValue() == null) {
            if (cacheEntry == null || time >= (Long)cacheEntry.getLeft()) {
                cachedInfo.put((Pair<Integer, class_2338>)key, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), null));
                OverlayRenderer.requestBlockInfo(mode, mouseOver, blockPos, player);
            }
            if (lastPair != null && time < lastPairTime + (long)Config.timeout) {
                OverlayRenderer.renderElements((ProbeInfo)lastPair.getRight(), Config.getDefaultOverlayStyle(), sw, sh, damageElement);
                lastRenderedTime = time;
            } else if (Config.waitingForServerTimeout > 0 && lastRenderedTime != -1L && time > lastRenderedTime + (long)Config.waitingForServerTimeout) {
                ProbeInfo info = OverlayRenderer.getWaitingInfo(mode, (class_3965)mouseOver, blockPos, player);
                OverlayRenderer.registerProbeInfo(dimension, blockPos, info);
                lastPair = Pair.of((Object)time, (Object)info);
                lastPairTime = time;
                OverlayRenderer.renderElements((ProbeInfo)lastPair.getRight(), Config.getDefaultOverlayStyle(), sw, sh, damageElement);
                lastRenderedTime = time;
            }
        } else {
            if (time > (Long)cacheEntry.getLeft() + (long)Config.timeout) {
                cachedInfo.put((Pair<Integer, class_2338>)key, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), (Object)cacheEntry.getRight()));
                OverlayRenderer.requestBlockInfo(mode, mouseOver, blockPos, player);
            }
            OverlayRenderer.renderElements((ProbeInfo)cacheEntry.getRight(), Config.getDefaultOverlayStyle(), sw, sh, damageElement);
            lastRenderedTime = time;
            lastPair = cacheEntry;
            lastPairTime = time;
        }
    }

    private static ProbeInfo getWaitingInfo(ProbeMode mode, class_3965 mouseOver, class_2338 blockPos, class_746 player) {
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        class_1937 world = player.method_5770();
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_11614();
        class_1799 pickBlock = block.method_9574((class_1922)world, blockPos, blockState);
        ProbeHitData data = new ProbeHitData(blockPos, mouseOver.method_17784(), mouseOver.method_17780(), pickBlock);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        try {
            DefaultProbeInfoProvider.showStandardBlockInfo(probeConfig, mode, probeInfo, blockState, block, world, blockPos, (class_1657)player, data);
        }
        catch (Exception e) {
            ThrowableIdentity.registerThrowable(e);
            probeInfo.text((Object)((Object)TextStyleClass.ERROR) + "Error (see log for details)!");
        }
        probeInfo.text((Object)((Object)TextStyleClass.ERROR) + "Waiting for server...");
        return probeInfo;
    }

    private static ProbeInfo getWaitingEntityInfo(ProbeMode mode, class_3966 mouseOver, class_1297 entity, class_746 player) {
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ProbeHitEntityData data = new ProbeHitEntityData(mouseOver.method_17784());
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        try {
            DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, probeConfig);
        }
        catch (Exception e) {
            ThrowableIdentity.registerThrowable(e);
            probeInfo.text((Object)((Object)TextStyleClass.ERROR) + "Error (see log for details)!");
        }
        probeInfo.text((Object)((Object)TextStyleClass.ERROR) + "Waiting for server...");
        return probeInfo;
    }

    private static void requestBlockInfo(ProbeMode mode, class_239 mouseOver, class_2338 blockPos, class_746 player) {
        class_1937 world = player.method_5770();
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_11614();
        class_1799 pickBlock = block.method_9574((class_1922)world, blockPos, blockState);
        if (pickBlock == null || !pickBlock.method_7960() && pickBlock.method_7909() == null) {
            pickBlock = class_1799.field_8037;
        }
        if (pickBlock != null && !pickBlock.method_7960() && Config.getDontSendNBTSet().contains(class_2378.field_11142.method_10221((Object)pickBlock.method_7909()))) {
            pickBlock = pickBlock.method_7972();
            pickBlock.method_7980(null);
        }
        NetworkInit.sendToServer(new PacketGetInfo(world.field_9247.method_12460().method_12484(), blockPos, mode, mouseOver, pickBlock));
    }

    public static void renderOverlay(IOverlayStyle style, IProbeInfo probeInfo) {
        GlStateManager.pushMatrix();
        double scale = Config.tooltipScale;
        class_310 minecraft = class_310.method_1551();
        double sw = minecraft.field_1704.method_4486();
        double sh = minecraft.field_1704.method_4502();
        OverlayRenderer.setupOverlayRendering(sw * scale, sh * scale);
        OverlayRenderer.renderElements((ProbeInfo)probeInfo, style, sw * scale, sh * scale, null);
        OverlayRenderer.setupOverlayRendering(sw, sh);
        GlStateManager.popMatrix();
    }

    private static void cleanupCachedBlocks(long time) {
        HashMap<Pair<Integer, class_2338>, Pair<Long, ProbeInfo>> newCachedInfo = new HashMap<Pair<Integer, class_2338>, Pair<Long, ProbeInfo>>();
        for (Map.Entry<Pair<Integer, class_2338>, Pair<Long, ProbeInfo>> entry : cachedInfo.entrySet()) {
            long t = (Long)entry.getValue().getLeft();
            if (time >= t + (long)Config.timeout + 1000L) continue;
            newCachedInfo.put(entry.getKey(), entry.getValue());
        }
        cachedInfo = newCachedInfo;
    }

    private static void cleanupCachedEntities(long time) {
        HashMap<UUID, Pair<Long, ProbeInfo>> newCachedInfo = new HashMap<UUID, Pair<Long, ProbeInfo>>();
        for (Map.Entry<UUID, Pair<Long, ProbeInfo>> entry : cachedEntityInfo.entrySet()) {
            long t = (Long)entry.getValue().getLeft();
            if (time >= t + (long)Config.timeout + 1000L) continue;
            newCachedInfo.put(entry.getKey(), entry.getValue());
        }
        cachedEntityInfo = newCachedInfo;
    }

    public static void renderElements(ProbeInfo probeInfo, IOverlayStyle style, double sw, double sh, @Nullable IElement extra) {
        if (extra != null) {
            probeInfo.element(extra);
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableLighting();
        int scaledWidth = (int)sw;
        int scaledHeight = (int)sh;
        int w = probeInfo.getWidth();
        int h = probeInfo.getHeight();
        int offset = style.getBorderOffset();
        int thick = style.getBorderThickness();
        int margin = 0;
        if (thick > 0) {
            w += (offset + thick + 3) * 2;
            h += (offset + thick + 3) * 2;
            margin = offset + thick + 3;
        }
        int x = style.getLeftX() != -1 ? style.getLeftX() : (style.getRightX() != -1 ? scaledWidth - w - style.getRightX() : (scaledWidth - w) / 2);
        int y = style.getTopY() != -1 ? style.getTopY() : (style.getBottomY() != -1 ? scaledHeight - h - style.getBottomY() : (scaledHeight - h) / 2);
        if (thick > 0) {
            if (offset > 0) {
                RenderHelper.drawThickBeveledBox(x, y, x + w - 1, y + h - 1, thick, style.getBoxColor(), style.getBoxColor(), style.getBoxColor());
            }
            RenderHelper.drawThickBeveledBox(x + offset, y + offset, x + w - 1 - offset, y + h - 1 - offset, thick, style.getBorderColor(), style.getBorderColor(), style.getBoxColor());
        }
        if (class_310.method_1551().field_1755 == null || !class_310.method_1551().field_1755.method_2222()) {
            RenderHelper.rot += 0.5f;
        }
        probeInfo.render(x + margin, y + margin);
        if (extra != null) {
            probeInfo.removeElement(extra);
        }
    }

    static {
        lastPairTime = 0L;
        lastRenderedTime = -1L;
    }
}

