/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.edibles;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.impl.SyntaxError;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import net.fabricmc.loader.FabricLoader;

public class ConfigManager {
    public static <T> T load(Class<T> clazz) {
        System.out.println("Loading config!");
        try {
            File file = new File(FabricLoader.INSTANCE.getConfigDirectory().toString() + "/Edibles.conf");
            Jankson jankson = Jankson.builder().build();
            if (!file.exists()) {
                ConfigManager.saveDefault(clazz.newInstance());
            }
            try {
                JsonObject json = jankson.load(file);
                return jankson.fromJson(json, clazz);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (SyntaxError syntaxError) {
            syntaxError.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void saveDefault(Object obj) {
        File configFile = new File(FabricLoader.INSTANCE.getConfigDirectory().toString() + "/Edibles.conf");
        Jankson jankson = Jankson.builder().build();
        String result = jankson.toJson(obj).toJson(true, true, 0);
        try {
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(configFile, false);
            out.write(result.getBytes());
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

