/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.edibles.mixins;

import io.github.cottonmc.edibles.Edibles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2421;
import net.minecraft.class_2511;
import net.minecraft.class_2614;
import net.minecraft.class_2615;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3830;
import net.minecraft.class_47;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2614.class})
public class MixinHopperHarvesting {
    @Inject(method={"extract(Lnet/minecraft/sortme/Hopper;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void hopperHarvest(class_2615 hopper, CallbackInfoReturnable cir) {
        if (Edibles.config.hopperHarvest) {
            class_2338 pos;
            class_1937 world = hopper.method_10997();
            class_2680 state = world.method_8320((pos = new class_2338(hopper.method_11266(), hopper.method_11264(), hopper.method_11265())).method_10079(class_2350.field_11036, 2));
            if (state.method_11614() instanceof class_2302) {
                if (MixinHopperHarvesting.harvestCrop(world, pos, state)) {
                    cir.setReturnValue((Object)true);
                }
            } else if (state.method_11614() instanceof class_3830) {
                if (MixinHopperHarvesting.harvestBerries(world, pos, state)) {
                    cir.setReturnValue((Object)true);
                }
            } else if (state.method_11614() instanceof class_2511) {
                if (MixinHopperHarvesting.harvestGourd(world, pos, state)) {
                    cir.setReturnValue((Object)true);
                }
            } else if (world.method_8320(pos.method_10093(class_2350.field_11036)).method_11614() instanceof class_2282) {
                if (MixinHopperHarvesting.harvestCocoa(world, pos)) {
                    cir.setReturnValue((Object)true);
                }
            } else if (state.method_11614() instanceof class_2421 && MixinHopperHarvesting.harvestNetherWart(world, pos, state)) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    private static boolean harvestCrop(class_1937 world, class_2338 pos, class_2680 state) {
        class_2302 crop = (class_2302)state.method_11614();
        if (crop.method_9827() == ((Integer)state.method_11654((class_2769)crop.method_9824())).intValue()) {
            System.out.println("Collection:");
            class_1263 inv = class_2614.method_11250((class_1937)world, (class_2338)pos);
            List results = state.method_11612(MixinHopperHarvesting.getLootContext(world, pos));
            List<class_1799> dropped = MixinHopperHarvesting.deepCopy(results);
            List<class_1799> remaining = MixinHopperHarvesting.attemptCollect(inv, results);
            if (!dropped.equals(results)) {
                if (remaining.size() > 0) {
                    MixinHopperHarvesting.spawnResults(world, pos.method_10079(class_2350.field_11036, 2), remaining);
                }
                world.method_8501(pos.method_10079(class_2350.field_11036, 2), (class_2680)state.method_11657((class_2769)crop.method_9824(), (Comparable)Integer.valueOf(0)));
                return true;
            }
        }
        return false;
    }

    private static boolean harvestBerries(class_1937 world, class_2338 pos, class_2680 state) {
        class_1263 inv = class_2614.method_11250((class_1937)world, (class_2338)pos);
        int age = (Integer)state.method_11654((class_2769)class_3830.field_17000);
        if (age == 3) {
            int berriesToDrop = 2 + world.field_9229.nextInt(2);
            ArrayList<class_1799> results = new ArrayList<class_1799>();
            results.add(new class_1799((class_1935)class_1802.field_16998, berriesToDrop));
            List<class_1799> dropped = MixinHopperHarvesting.deepCopy(results);
            List<class_1799> remaining = MixinHopperHarvesting.attemptCollect(inv, results);
            if (!dropped.equals(results)) {
                if (remaining.size() > 0) {
                    MixinHopperHarvesting.spawnResults(world, pos.method_10079(class_2350.field_11036, 2), remaining);
                }
                world.method_8501(pos.method_10079(class_2350.field_11036, 2), (class_2680)state.method_11657((class_2769)class_3830.field_17000, (Comparable)Integer.valueOf(1)));
                return true;
            }
        }
        return false;
    }

    private static boolean harvestGourd(class_1937 world, class_2338 pos, class_2680 state) {
        class_1263 inv = class_2614.method_11250((class_1937)world, (class_2338)pos);
        class_2338 gourdPos = pos.method_10079(class_2350.field_11036, 2);
        List results = state.method_11612(MixinHopperHarvesting.getLootContext(world, pos));
        List<class_1799> dropped = MixinHopperHarvesting.deepCopy(results);
        List<class_1799> remaining = MixinHopperHarvesting.attemptCollect(inv, results);
        if (!dropped.equals(results)) {
            if (remaining.size() > 0) {
                MixinHopperHarvesting.spawnResults(world, gourdPos, remaining);
            }
            world.method_8651(gourdPos, false);
            return true;
        }
        return false;
    }

    private static boolean harvestCocoa(class_1937 world, class_2338 pos) {
        class_2338 cocoaPos = pos.method_10093(class_2350.field_11036);
        class_2680 cocoaState = world.method_8320(cocoaPos);
        int age = (Integer)cocoaState.method_11654((class_2769)class_2282.field_10779);
        if (age == 2) {
            class_1263 inv = class_2614.method_11250((class_1937)world, (class_2338)pos);
            List results = cocoaState.method_11612(MixinHopperHarvesting.getLootContext(world, cocoaPos));
            List<class_1799> dropped = MixinHopperHarvesting.deepCopy(results);
            List<class_1799> remaining = MixinHopperHarvesting.attemptCollect(inv, results);
            if (!dropped.equals(results)) {
                if (remaining.size() > 0) {
                    MixinHopperHarvesting.spawnResults(world, cocoaPos, remaining);
                }
                world.method_8501(cocoaPos, (class_2680)cocoaState.method_11657((class_2769)class_2282.field_10779, (Comparable)Integer.valueOf(0)));
                return true;
            }
        }
        return false;
    }

    private static boolean harvestNetherWart(class_1937 world, class_2338 pos, class_2680 state) {
        if ((Integer)state.method_11654((class_2769)class_2421.field_11306) == 3) {
            class_1263 inv = class_2614.method_11250((class_1937)world, (class_2338)pos);
            List results = state.method_11612(MixinHopperHarvesting.getLootContext(world, pos));
            List<class_1799> dropped = MixinHopperHarvesting.deepCopy(results);
            List<class_1799> remaining = MixinHopperHarvesting.attemptCollect(inv, results);
            if (!dropped.equals(results)) {
                if (remaining.size() > 0) {
                    MixinHopperHarvesting.spawnResults(world, pos.method_10079(class_2350.field_11036, 2), remaining);
                }
                world.method_8501(pos.method_10079(class_2350.field_11036, 2), (class_2680)state.method_11657((class_2769)class_2421.field_11306, (Comparable)Integer.valueOf(0)));
                return true;
            }
        }
        return false;
    }

    private static class_47.class_48 getLootContext(class_1937 world, class_2338 pos) {
        return new class_47.class_48(world.method_8503().method_3847(world.field_9247.method_12460())).method_312(class_181.field_1232, (Object)pos).method_312(class_181.field_1229, (Object)class_1799.field_8037);
    }

    private static List<class_1799> attemptCollect(class_1263 inv, List<class_1799> results) {
        ArrayList<class_1799> remaining = new ArrayList<class_1799>();
        for (int i = 0; i < results.size(); ++i) {
            class_1799 insert = class_2614.method_11260(null, (class_1263)inv, (class_1799)results.get(i), null);
            remaining.add(insert);
        }
        return remaining;
    }

    private static List<class_1799> deepCopy(List<class_1799> original) {
        ArrayList<class_1799> copied = new ArrayList<class_1799>();
        for (class_1799 stack : original) {
            copied.add(stack.method_7972());
        }
        return copied;
    }

    private static void spawnResults(class_1937 world, class_2338 spawnAt, List<class_1799> toSpawn) {
        for (int i = 0; i < toSpawn.size(); ++i) {
            world.method_8649((class_1297)new class_1542(world, (double)spawnAt.method_10263(), (double)spawnAt.method_10264(), (double)spawnAt.method_10260(), toSpawn.get(i)));
        }
    }
}

