/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric;

import com.jamieswhiteshirt.clotheslinefabric.common.block.ClotheslineBlocks;
import com.jamieswhiteshirt.clotheslinefabric.common.event.ChunkLoadCallback;
import com.jamieswhiteshirt.clotheslinefabric.common.event.ChunkWatchCallback;
import com.jamieswhiteshirt.clotheslinefabric.common.event.TrackEntityCallback;
import com.jamieswhiteshirt.clotheslinefabric.common.item.ClotheslineItems;
import com.jamieswhiteshirt.clotheslinefabric.common.network.MessageChannels;
import com.jamieswhiteshirt.clotheslinefabric.common.network.ServerMessageHandling;
import com.jamieswhiteshirt.clotheslinefabric.common.network.message.ResetConnectorStateMessage;
import com.jamieswhiteshirt.clotheslinefabric.common.network.message.SetConnectorStateMessage;
import com.jamieswhiteshirt.clotheslinefabric.common.sound.ClotheslineSoundEvents;
import com.jamieswhiteshirt.clotheslinefabric.internal.ConnectorHolder;
import com.jamieswhiteshirt.clotheslinefabric.internal.WorldExtension;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.world.WorldTickCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_3965;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Clothesline
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"clothesline-fabric");

    public void onInitialize() {
        ClotheslineBlocks.init();
        ClotheslineItems.init();
        ClotheslineSoundEvents.init();
        ServerMessageHandling.init();
        WorldTickCallback.EVENT.register(world -> ((WorldExtension)world).clotheslineTick());
        ChunkWatchCallback.WATCH.register((world, pos, playerEntity) -> ((WorldExtension)world).onPlayerWatchChunk(pos, playerEntity));
        ChunkWatchCallback.UNWATCH.register((world, pos, playerEntity) -> ((WorldExtension)world).onPlayerUnWatchChunk(pos, playerEntity));
        ChunkLoadCallback.LOAD.register((world, pos) -> ((WorldExtension)world).onChunkLoaded(pos));
        ChunkLoadCallback.UNLOAD.register((world, pos) -> ((WorldExtension)world).onChunkUnloaded(pos));
        TrackEntityCallback.START.register((player, entity) -> {
            if (entity instanceof ConnectorHolder) {
                player.field_13987.method_14364((class_2596)Clothesline.createConnectorStatePacket(((ConnectorHolder)entity).getFrom(), entity));
            }
        });
    }

    public static class_1268 getUsageHand(class_1838 ctx) {
        class_1657 player = ctx.method_8036();
        if (player == null) {
            return null;
        }
        for (class_1268 hand : class_1268.values()) {
            if (player.method_5998(hand) != ctx.method_8041()) continue;
            return hand;
        }
        return null;
    }

    public static class_2658 createConnectorStatePacket(class_1838 ctx, class_1297 entity) {
        if (ctx != null) {
            return MessageChannels.SET_CONNECTOR_STATE.createClientboundPacket(new SetConnectorStateMessage(entity.method_5628(), Clothesline.getUsageHand(ctx), new class_3965(ctx.method_17698(), ctx.method_8038(), ctx.method_8037(), ctx.method_17699())));
        }
        return MessageChannels.RESET_CONNECTOR_STATE.createClientboundPacket(new ResetConnectorStateMessage(entity.method_5628()));
    }
}

