/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.api;

import com.jamieswhiteshirt.clotheslinefabric.api.DeltaComparator;
import com.jamieswhiteshirt.clotheslinefabric.api.Line;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public final class Path {
    private final Map<class_2338, Node> nodes;
    private final List<Edge> edges;

    public Path(Map<class_2338, Node> nodes, List<Edge> edges) {
        this.nodes = nodes;
        this.edges = edges;
    }

    public int getLength() {
        if (this.edges.isEmpty()) {
            return 0;
        }
        return this.edges.get(this.edges.size() - 1).toOffset;
    }

    public Map<class_2338, Node> getNodes() {
        return this.nodes;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    private Edge getEdgeForPosition(int offset, int fromIndex, int toIndex) {
        if (fromIndex != toIndex) {
            int middleIndex = (fromIndex + toIndex) / 2;
            Edge edge = this.edges.get(middleIndex);
            if (offset < edge.fromOffset) {
                return this.getEdgeForPosition(offset, fromIndex, middleIndex);
            }
            if (offset >= edge.toOffset) {
                return this.getEdgeForPosition(offset, middleIndex + 1, toIndex);
            }
            return edge;
        }
        return this.edges.get(fromIndex);
    }

    public Edge getEdgeForPosition(int offset) {
        return this.getEdgeForPosition(offset, 0, this.edges.size());
    }

    public class_243 getPositionForOffset(int offset) {
        return this.getEdgeForPosition(offset).getPositionForOffset(offset);
    }

    public boolean isEmpty() {
        return this.edges.isEmpty();
    }

    public static final class Edge {
        private final class_2338 delta;
        private final Line line;
        private final int fromOffset;
        private final int toOffset;

        public Edge(class_2338 delta, Line line, int fromOffset, int toOffset) {
            this.delta = delta;
            this.line = line;
            this.fromOffset = fromOffset;
            this.toOffset = toOffset;
        }

        public class_2338 getDelta() {
            return this.delta;
        }

        public Line getLine() {
            return this.line;
        }

        public int getFromOffset() {
            return this.fromOffset;
        }

        public int getToOffset() {
            return this.toOffset;
        }

        public int getLength() {
            return this.toOffset - this.fromOffset;
        }

        public class_243 getPositionForOffset(int offset) {
            double scalar = (double)(offset - this.getFromOffset()) / (double)(this.getToOffset() - this.getFromOffset());
            return this.line.getPosition(scalar);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return this.fromOffset == edge.fromOffset && this.toOffset == edge.toOffset && Objects.equals(this.line, edge.line);
        }

        public int hashCode() {
            return Objects.hash(this.line, this.fromOffset, this.toOffset);
        }
    }

    public static final class Node {
        private final class_2338 pos;
        private final List<Edge> edges;
        private final int baseRotation;

        public Node(class_2338 pos, List<Edge> edges, int baseRotation) {
            this.pos = pos;
            this.edges = edges;
            this.baseRotation = baseRotation;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public List<Edge> getEdges() {
            return this.edges;
        }

        public int getBaseRotation() {
            return this.baseRotation;
        }

        private int flooredEdgeIndex(class_2382 delta, int left, int right) {
            while (left < right) {
                int mid = (left + right) / 2;
                int comparison = DeltaComparator.getInstance().compare((class_2382)this.edges.get(mid).delta, delta);
                if (comparison > 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            return left;
        }

        private int flooredEdgeIndex(class_2382 delta) {
            return this.flooredEdgeIndex(delta, 0, this.edges.size());
        }

        public int getOffsetForDelta(class_2382 delta) {
            return this.edges.get(this.flooredEdgeIndex(delta) % this.edges.size()).fromOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.baseRotation == node.baseRotation && Objects.equals(this.pos, node.pos) && Objects.equals(this.edges, node.edges);
        }

        public int hashCode() {
            return Objects.hash(this.pos, this.edges, this.baseRotation);
        }
    }
}

