/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.api;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2338;

public final class Tree {
    private final class_2338 pos;
    private final List<Edge> edges;
    private final int minOffset;
    private final int maxOffset;
    private final int baseRotation;

    public static Tree empty(class_2338 pos, int offset, int baseRotation) {
        return new Tree(pos, Collections.emptyList(), offset, offset, baseRotation);
    }

    public Tree(class_2338 pos, List<Edge> edges, int minOffset, int maxOffset, int baseRotation) {
        this.pos = pos;
        this.edges = edges;
        this.minOffset = minOffset;
        this.maxOffset = maxOffset;
        this.baseRotation = baseRotation;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public int getBaseRotation() {
        return this.baseRotation;
    }

    public boolean isEmpty() {
        return this.edges.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tree that = (Tree)o;
        return this.minOffset == that.minOffset && this.maxOffset == that.maxOffset && this.baseRotation == that.baseRotation && Objects.equals(this.pos, that.pos) && Objects.equals(this.edges, that.edges);
    }

    public int hashCode() {
        return Objects.hash(this.minOffset, this.maxOffset, this.pos, this.edges);
    }

    public String toString() {
        return "Tree{pos=" + this.pos + ", edges=" + this.edges + ", minOffset=" + this.minOffset + ", maxOffset=" + this.maxOffset + ", baseRotation=" + this.baseRotation + '}';
    }

    public static final class Edge {
        private final class_2338 delta;
        private final int length;
        private final int preMinOffset;
        private final Tree tree;

        public Edge(class_2338 delta, int length, int preMinOffset, Tree tree) {
            this.delta = delta;
            this.length = length;
            this.preMinOffset = preMinOffset;
            this.tree = tree;
        }

        public class_2338 getDelta() {
            return this.delta;
        }

        public int getLength() {
            return this.length;
        }

        public Tree getTree() {
            return this.tree;
        }

        public int getPreMinOffset() {
            return this.preMinOffset;
        }

        public int getPreMaxOffset() {
            return this.preMinOffset + this.length;
        }

        public int getPostMinOffset() {
            return this.tree.maxOffset;
        }

        public int getPostMaxOffset() {
            return this.tree.maxOffset + this.length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return this.length == edge.length && this.preMinOffset == edge.preMinOffset && Objects.equals(this.delta, edge.delta) && Objects.equals(this.tree, edge.tree);
        }

        public int hashCode() {
            return Objects.hash(this.delta, this.length, this.preMinOffset, this.tree);
        }

        public String toString() {
            return "Edge{delta=" + this.delta + ", length=" + this.length + ", preMinOffset=" + this.preMinOffset + ", tree=" + this.tree + '}';
        }
    }
}

