/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class MutableSortedIntMap<T> {
    private final ArrayList<Entry<T>> entries;
    private final int maxKey;

    private int findKeyIndex(int key, int minIndex, int maxIndex) {
        if (minIndex != maxIndex) {
            int middleIndex = (minIndex + maxIndex) / 2;
            int comparison = Integer.compare(key, this.entries.get(middleIndex).getKey());
            if (comparison < 0) {
                return this.findKeyIndex(key, minIndex, middleIndex);
            }
            if (comparison > 0) {
                return this.findKeyIndex(key, middleIndex + 1, maxIndex);
            }
            return middleIndex;
        }
        return minIndex;
    }

    private int findKeyIndex(int key) {
        return this.findKeyIndex(key, 0, this.entries.size());
    }

    public static <T> MutableSortedIntMap<T> build(Map<Integer, T> map, int maxKey) {
        return new MutableSortedIntMap<T>(new ArrayList<Entry<T>>(map.entrySet().stream().map(entry -> new Entry((Integer)entry.getKey(), entry.getValue())).collect(Collectors.toList())), maxKey);
    }

    public static <T> MutableSortedIntMap<T> empty(int maxKey) {
        return new MutableSortedIntMap<T>(new ArrayList<Entry<T>>(), maxKey);
    }

    public static <T> MutableSortedIntMap<T> concatenate(List<MutableSortedIntMap<T>> subMaps) {
        ArrayList<Entry<T>> entries = new ArrayList<Entry<T>>(subMaps.stream().mapToInt(MutableSortedIntMap::size).sum());
        int maxKey = 0;
        for (MutableSortedIntMap<T> subMap : subMaps) {
            for (Entry<T> entry : subMap.entries) {
                entries.add(new Entry<Object>(((Entry)entry).key + maxKey, ((Entry)entry).value));
            }
            maxKey += subMap.maxKey;
        }
        return new MutableSortedIntMap<T>(entries, maxKey);
    }

    public MutableSortedIntMap(ArrayList<Entry<T>> entries, int maxKey) {
        this.entries = entries;
        this.maxKey = maxKey;
    }

    @Nullable
    public T get(int key) {
        int keyIndex = this.findKeyIndex(key);
        if (keyIndex >= this.entries.size() || ((Entry)this.entries.get(keyIndex)).key != key) {
            return null;
        }
        return (T)((Entry)this.entries.get(keyIndex)).value;
    }

    public List<Entry<T>> getInRange(int minKey, int maxKey) {
        int minIndex = this.findKeyIndex(minKey);
        int maxIndex = this.findKeyIndex(maxKey);
        if (minKey <= maxKey) {
            return this.entries.subList(minIndex, maxIndex);
        }
        ArrayList<Entry<T>> entries = new ArrayList<Entry<T>>(minIndex + this.entries().size() - maxIndex);
        entries.addAll(this.entries.subList(minIndex, this.entries.size()));
        entries.addAll(this.entries.subList(0, maxIndex));
        return entries;
    }

    public void put(int key, T value) {
        int keyIndex = this.findKeyIndex(key);
        Entry<T> entry = new Entry<T>(key, value);
        if (keyIndex >= this.entries.size() || ((Entry)this.entries.get(keyIndex)).key != key) {
            this.entries.add(keyIndex, entry);
        } else {
            this.entries.set(keyIndex, entry);
        }
    }

    public void remove(int key) {
        int keyIndex = this.findKeyIndex(key);
        if (keyIndex < this.entries.size() && ((Entry)this.entries.get(keyIndex)).key == key) {
            this.entries.remove(keyIndex);
        }
    }

    public List<Entry<T>> entries() {
        return this.entries;
    }

    public int getMaxKey() {
        return this.maxKey;
    }

    public int size() {
        return this.entries.size();
    }

    public MutableSortedIntMap<T> shiftedSubMap(int minKey, int maxKey) {
        int minIndex = this.findKeyIndex(minKey);
        int maxIndex = this.findKeyIndex(maxKey);
        return new MutableSortedIntMap<T>(new ArrayList<Entry<T>>(this.entries.subList(minIndex, maxIndex).stream().map(entry -> new Entry(entry.getKey() - minKey, entry.getValue())).collect(Collectors.toList())), maxKey - minKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableSortedIntMap that = (MutableSortedIntMap)o;
        return this.maxKey == that.maxKey && Objects.equals(this.entries, that.entries);
    }

    public int hashCode() {
        return Objects.hash(this.entries, this.maxKey);
    }

    public String toString() {
        return "MutableSortedIntMap{entries=" + this.entries + ", maxKey=" + this.maxKey + '}';
    }

    public static final class Entry<T> {
        private final int key;
        private final T value;

        public Entry(int key, T value) {
            this.key = key;
            this.value = value;
        }

        public int getKey() {
            return this.key;
        }

        public T getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.key == entry.key && Objects.equals(this.value, entry.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return "Entry{key=" + this.key + ", value=" + this.value + '}';
        }
    }
}

