/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.client;

import com.jamieswhiteshirt.clotheslinefabric.api.NetworkEdge;
import com.jamieswhiteshirt.clotheslinefabric.api.Path;
import com.jamieswhiteshirt.clotheslinefabric.client.LineProjection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public final class EdgeAttachmentProjector {
    private final int fromOffset;
    private final int toOffset;
    private final LineProjection projection;
    private final float angleY;
    private final float fromAngleDiff;
    private final float toAngleDiff;

    private EdgeAttachmentProjector(int fromOffset, int toOffset, LineProjection projection, float angleY, float fromAngleDiff, float toAngleDiff) {
        this.fromOffset = fromOffset;
        this.toOffset = toOffset;
        this.projection = projection;
        this.angleY = angleY;
        this.fromAngleDiff = fromAngleDiff;
        this.toAngleDiff = toAngleDiff;
    }

    private static float floorModAngle(float angle) {
        if (angle >= 0.0f) {
            return angle % 360.0f;
        }
        return 360.0f + angle % 360.0f;
    }

    private static float calculateGlobalAngleY(class_2338 delta) {
        return EdgeAttachmentProjector.floorModAngle((float)Math.toDegrees(Math.atan2(delta.method_10260(), delta.method_10263())));
    }

    private static float angleBetween(Path.Edge a, Path.Edge b) {
        float angleA = EdgeAttachmentProjector.calculateGlobalAngleY(a.getDelta());
        float angleB = EdgeAttachmentProjector.calculateGlobalAngleY(b.getDelta());
        return EdgeAttachmentProjector.floorModAngle(angleA - angleB);
    }

    public static EdgeAttachmentProjector build(Path.Edge fromPathEdge, Path.Edge pathEdge, Path.Edge toPathEdge, LineProjection projection) {
        return new EdgeAttachmentProjector(pathEdge.getFromOffset(), pathEdge.getToOffset(), projection, EdgeAttachmentProjector.calculateGlobalAngleY(pathEdge.getDelta()), EdgeAttachmentProjector.angleBetween(fromPathEdge, pathEdge), EdgeAttachmentProjector.angleBetween(pathEdge, toPathEdge));
    }

    public static EdgeAttachmentProjector build(NetworkEdge edge) {
        int index = edge.getIndex();
        List<Path.Edge> edges = edge.getNetwork().getState().getPath().getEdges();
        Path.Edge fromPathEdge = edges.get(Math.floorMod(index - 1, edges.size()));
        Path.Edge toPathEdge = edges.get(Math.floorMod(index + 1, edges.size()));
        return EdgeAttachmentProjector.build(fromPathEdge, edge.getPathEdge(), toPathEdge, LineProjection.create(edge));
    }

    private float calculateSwingAngle(double momentum, double offset) {
        double angleDiff;
        double t;
        if (momentum == 0.0) {
            return 0.0f;
        }
        if (momentum > 0.0) {
            t = offset - (double)this.fromOffset;
            angleDiff = this.fromAngleDiff;
        } else {
            t = (double)this.toOffset - offset;
            angleDiff = this.toAngleDiff;
        }
        float speedRatio = (float)momentum / 160.0f;
        float swingMax = 6.0f * (float)angleDiff * speedRatio * speedRatio;
        return swingMax * (float)Math.exp(-t / 320.0) * class_3532.method_15374((float)((float)(Math.PI * t / 160.0)));
    }

    private static class_1159 translate(float x, float y, float z) {
        return new class_1159(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, x, y, z, 1.0f});
    }

    private static class_1159 scale(float x, float y, float z) {
        return new class_1159(new float[]{x, 0.0f, 0.0f, 0.0f, 0.0f, y, 0.0f, 0.0f, 0.0f, 0.0f, z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    }

    private static class_1159 rotateY(float angle) {
        float cos = class_3532.method_15362((float)angle);
        float sin = class_3532.method_15374((float)angle);
        return new class_1159(new float[]{cos, 0.0f, -sin, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, sin, 0.0f, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    }

    private static class_1159 rotateX(float angle) {
        float cos = class_3532.method_15362((float)angle);
        float sin = class_3532.method_15374((float)angle);
        return new class_1159(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, cos, sin, 0.0f, 0.0f, -sin, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    }

    public class_1159 getL2WForAttachment(double momentum, double offset, float delta) {
        double relativeOffset = offset - (double)this.fromOffset;
        double edgePosScalar = relativeOffset / (double)(this.toOffset - this.fromOffset);
        class_243 pos = this.projection.projectRUF(-0.125, 0.0, edgePosScalar);
        float swingAngle = this.calculateSwingAngle(momentum, offset);
        class_1159 result = EdgeAttachmentProjector.translate((float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350);
        result.method_4935(EdgeAttachmentProjector.scale(0.5f, 0.5f, 0.5f));
        result.method_4935(EdgeAttachmentProjector.rotateY((float)Math.toRadians(-this.angleY)));
        result.method_4935(EdgeAttachmentProjector.rotateX((float)Math.toRadians(swingAngle)));
        result.method_4935(EdgeAttachmentProjector.translate(0.0f, -0.5f, 0.0f));
        return result;
    }

    public class_1159 getW2LForAttachment(double momentum, double offset, float delta) {
        double relativeOffset = offset - (double)this.fromOffset;
        double edgePosScalar = relativeOffset / (double)(this.toOffset - this.fromOffset);
        class_243 pos = this.projection.projectRUF(-0.125, 0.0, edgePosScalar);
        float swingAngle = this.calculateSwingAngle(momentum, offset);
        class_1159 result = EdgeAttachmentProjector.translate(0.0f, 0.5f, 0.0f);
        result.method_4935(EdgeAttachmentProjector.rotateX((float)Math.toRadians(-swingAngle)));
        result.method_4935(EdgeAttachmentProjector.rotateY((float)Math.toRadians(this.angleY)));
        result.method_4935(EdgeAttachmentProjector.scale(2.0f, 2.0f, 2.0f));
        result.method_4935(EdgeAttachmentProjector.translate((float)(-pos.field_1352), (float)(-pos.field_1351), (float)(-pos.field_1350)));
        return result;
    }
}

