/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.client.raytrace;

import com.jamieswhiteshirt.clotheslinefabric.api.Network;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkEdge;
import com.jamieswhiteshirt.clotheslinefabric.client.LineProjection;
import com.jamieswhiteshirt.clotheslinefabric.client.raytrace.NetworkRaytraceHit;
import com.jamieswhiteshirt.clotheslinefabric.client.render.RenderClotheslineNetwork;
import com.jamieswhiteshirt.clotheslinefabric.common.item.ClotheslineItems;
import com.jamieswhiteshirt.clotheslinefabric.common.network.MessageChannels;
import com.jamieswhiteshirt.clotheslinefabric.common.network.message.HitNetworkMessage;
import com.jamieswhiteshirt.clotheslinefabric.common.network.message.TryUseItemOnNetworkMessage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

@Environment(value=EnvType.CLIENT)
public class EdgeRaytraceHit
extends NetworkRaytraceHit {
    public final double offset;

    public EdgeRaytraceHit(double distanceSq, NetworkEdge edge, double offset) {
        super(distanceSq, edge);
        this.offset = offset;
    }

    @Override
    public boolean hitByEntity(class_1657 player) {
        int offset = (int)Math.round(this.offset);
        Network network = this.edge.getNetwork();
        int attachmentKey = network.getState().offsetToAttachmentKey(offset);
        class_243 pos = this.edge.getPathEdge().getPositionForOffset(offset);
        player.field_6002.method_8465(player, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_15184, class_3419.field_15245, 1.0f, 1.0f);
        class_310.method_1551().method_1562().method_2883((class_2596)MessageChannels.HIT_NETWORK.createServerboundPacket(new HitNetworkMessage(network.getId(), attachmentKey, offset)));
        return true;
    }

    @Override
    public boolean useItem(class_1657 player, class_1268 hand) {
        int offset = (int)Math.round(this.offset);
        Network network = this.edge.getNetwork();
        int attachmentKey = network.getState().offsetToAttachmentKey(offset);
        class_310.method_1551().method_1562().method_2883((class_2596)MessageChannels.TRY_USE_ITEM_ON_NETWORK.createServerboundPacket(new TryUseItemOnNetworkMessage(hand, network.getId(), attachmentKey)));
        return network.useItem(player, hand, attachmentKey);
    }

    @Override
    public void renderHighlight(RenderClotheslineNetwork renderClotheslineNetwork, float delta, double x, double y, double z, float r, float g, float b, float a) {
        renderClotheslineNetwork.renderOutline(LineProjection.create(this.edge), x, y, z, r, g, b, a);
    }

    @Override
    public class_1799 getPickedResult() {
        return new class_1799((class_1935)ClotheslineItems.CLOTHESLINE);
    }

    @Override
    public String getDebugString() {
        return "Position: " + this.offset;
    }
}

