/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.client.raytrace;

import com.jamieswhiteshirt.clotheslinefabric.api.NetworkEdge;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkManager;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkState;
import com.jamieswhiteshirt.clotheslinefabric.api.Path;
import com.jamieswhiteshirt.clotheslinefabric.api.util.MutableSortedIntMap;
import com.jamieswhiteshirt.clotheslinefabric.client.EdgeAttachmentProjector;
import com.jamieswhiteshirt.clotheslinefabric.client.LineProjection;
import com.jamieswhiteshirt.clotheslinefabric.client.raytrace.AttachmentRaytraceHit;
import com.jamieswhiteshirt.clotheslinefabric.client.raytrace.EdgeRaytraceHit;
import com.jamieswhiteshirt.clotheslinefabric.client.raytrace.NetworkRaytraceHit;
import com.jamieswhiteshirt.clotheslinefabric.client.raytrace.Ray;
import com.jamieswhiteshirt.rtree3i.Box;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1162;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class Raytracing {
    private static final class_238 ATTACHMENT_BOX = new class_238(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5);

    @Nullable
    public static NetworkRaytraceHit raytraceNetworks(NetworkManager manager, Ray ray, double maxDistanceSq, float delta) {
        Box box = Box.create((int)Math.floor(Math.min(ray.from.field_1352, ray.to.field_1352) - 0.5), (int)Math.floor(Math.min(ray.from.field_1351, ray.to.field_1351) - 0.5), (int)Math.floor(Math.min(ray.from.field_1350, ray.to.field_1350) - 0.5), (int)Math.ceil(Math.max(ray.from.field_1352, ray.to.field_1352) + 0.5), (int)Math.ceil(Math.max(ray.from.field_1351, ray.to.field_1351) + 0.5), (int)Math.ceil(Math.max(ray.from.field_1350, ray.to.field_1350) + 0.5));
        NetworkRaytraceHit hit = null;
        List edges = manager.getNetworks().getEdges().values(box::intersects).collect(Collectors.toList());
        for (NetworkEdge edge : edges) {
            NetworkRaytraceHit hitCandidate = Raytracing.raytraceEdge(ray, edge, maxDistanceSq, delta);
            if (hitCandidate == null || !(hitCandidate.distanceSq < maxDistanceSq)) continue;
            maxDistanceSq = hitCandidate.distanceSq;
            hit = hitCandidate;
        }
        return hit;
    }

    @Nullable
    private static NetworkRaytraceHit raytraceEdge(Ray viewRay, NetworkEdge edge, double maxDistanceSq, float delta) {
        double toAttachmentKey;
        double fromAttachmentKey;
        NetworkState state;
        List<MutableSortedIntMap.Entry<class_1799>> attachments;
        Path.Edge pathEdge = edge.getPathEdge();
        LineProjection projection = LineProjection.create(edge);
        NetworkRaytraceHit hit = null;
        Ray edgeRay = new Ray(projection.projectRUF(-0.125, 0.0, 0.0), projection.projectRUF(-0.125, 0.0, 1.0));
        double b = viewRay.delta.method_1026(edgeRay.delta);
        class_243 w0 = viewRay.from.method_1020(edgeRay.from);
        double denominator = viewRay.lengthSq * edgeRay.lengthSq - b * b;
        if (denominator != 0.0) {
            double rayLengthSquared;
            double d = viewRay.delta.method_1026(w0);
            double e = edgeRay.delta.method_1026(w0);
            double viewDeltaScalar = class_3532.method_15350((double)((b * e - edgeRay.lengthSq * d) / denominator), (double)0.0, (double)1.0);
            double edgeDeltaScalar = class_3532.method_15350((double)((viewRay.lengthSq * e - b * d) / denominator), (double)0.0, (double)1.0);
            class_243 viewNear = viewRay.project(viewDeltaScalar);
            class_243 edgeNear = edgeRay.project(edgeDeltaScalar);
            class_243 nearDelta = edgeNear.method_1020(viewNear);
            if (nearDelta.method_1027() < 0.00390625 && (rayLengthSquared = viewNear.method_1020(viewRay.from).method_1027()) < maxDistanceSq) {
                double offset = (double)pathEdge.getFromOffset() * (1.0 - edgeDeltaScalar) + (double)pathEdge.getToOffset() * edgeDeltaScalar;
                hit = new EdgeRaytraceHit(rayLengthSquared, edge, offset);
            }
        }
        if (!(attachments = (state = edge.getNetwork().getState()).getAttachmentsInRange((int)(fromAttachmentKey = state.offsetToAttachmentKey(pathEdge.getFromOffset(), delta)), (int)(toAttachmentKey = state.offsetToAttachmentKey(pathEdge.getToOffset(), delta)))).isEmpty()) {
            class_1162 lFrom = new class_1162();
            class_1162 lTo = new class_1162();
            class_1162 wHitVec = new class_1162();
            EdgeAttachmentProjector projector = EdgeAttachmentProjector.build(edge);
            for (MutableSortedIntMap.Entry<class_1799> attachment : attachments) {
                double attachmentOffset = state.attachmentKeyToOffset(attachment.getKey(), delta);
                class_1159 l2w = projector.getL2WForAttachment(state.getMomentum(delta), attachmentOffset, delta);
                class_1159 w2l = projector.getW2LForAttachment(state.getMomentum(delta), attachmentOffset, delta);
                lFrom.method_4955((float)viewRay.from.field_1352, (float)viewRay.from.field_1351, (float)viewRay.from.field_1350, 1.0f);
                lFrom.method_4960(w2l);
                lTo.method_4955((float)viewRay.to.field_1352, (float)viewRay.to.field_1351, (float)viewRay.to.field_1350, 1.0f);
                lTo.method_4960(w2l);
                Optional lResult = ATTACHMENT_BOX.method_992(new class_243((double)lFrom.method_4953(), (double)lFrom.method_4956(), (double)lFrom.method_4957()), new class_243((double)lTo.method_4953(), (double)lTo.method_4956(), (double)lTo.method_4957()));
                if (!lResult.isPresent()) continue;
                class_243 lHitVec = (class_243)lResult.get();
                wHitVec.method_4955((float)lHitVec.field_1352, (float)lHitVec.field_1351, (float)lHitVec.field_1350, 1.0f);
                wHitVec.method_4960(l2w);
                double distanceSq = new class_243((double)wHitVec.method_4953(), (double)wHitVec.method_4956(), (double)wHitVec.method_4957()).method_1025(viewRay.from);
                if (!(distanceSq < maxDistanceSq)) continue;
                maxDistanceSq = distanceSq;
                hit = new AttachmentRaytraceHit(distanceSq, edge, attachment.getKey(), l2w);
            }
        }
        return hit;
    }
}

