/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.client.render;

import com.jamieswhiteshirt.clotheslinefabric.api.Line;
import com.jamieswhiteshirt.clotheslinefabric.api.Network;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkEdge;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkNode;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkState;
import com.jamieswhiteshirt.clotheslinefabric.api.Path;
import com.jamieswhiteshirt.clotheslinefabric.api.Utility;
import com.jamieswhiteshirt.clotheslinefabric.api.util.MutableSortedIntMap;
import com.jamieswhiteshirt.clotheslinefabric.client.EdgeAttachmentProjector;
import com.jamieswhiteshirt.clotheslinefabric.client.LineProjection;
import com.jamieswhiteshirt.clotheslinefabric.client.render.BakedModels;
import com.jamieswhiteshirt.clotheslinefabric.client.render.ItemModelRenderer;
import com.jamieswhiteshirt.clotheslinefabric.common.block.ClotheslineAnchorBlock;
import com.jamieswhiteshirt.clotheslinefabric.common.block.ClotheslineBlocks;
import com.jamieswhiteshirt.clotheslinefabric.internal.ConnectorHolder;
import com.jamieswhiteshirt.rtree3i.RTreeMap;
import com.jamieswhiteshirt.rtree3i.Selection;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_1159;
import net.minecraft.class_1162;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_311;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_757;
import net.minecraft.class_809;
import net.minecraft.class_824;
import net.minecraft.class_856;

@Environment(value=EnvType.CLIENT)
public final class RenderClotheslineNetwork {
    private static final class_2960 TEXTURE = new class_2960("clothesline-fabric", "textures/misc/clothesline.png");
    private static final class_293 VERTEX_FORMAT = new class_293().method_1361(class_290.field_1587).method_1361(class_290.field_1579).method_1361(class_290.field_1591).method_1361(class_290.field_1583);
    private static final double[] RIGHT_MULTIPLIERS = new double[]{-1.0, -1.0, 1.0, 1.0, -1.0};
    private static final double[] UP_MULTIPLIERS = new double[]{-1.0, 1.0, 1.0, -1.0, -1.0};
    private static final double[] NORMAL_RIGHT_MULTIPLIERS = new double[]{-1.0, 0.0, 1.0, 0.0};
    private static final double[] NORMAL_UP_MULTIPLIERS = new double[]{0.0, 1.0, 0.0, -1.0};
    private final class_310 client;

    public RenderClotheslineNetwork(class_310 client) {
        this.client = client;
    }

    private static class_287 pos(class_287 bufferBuilder, class_243 pos) {
        return bufferBuilder.method_1315(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    private static class_287 posNormal(class_287 bufferBuilder, class_243 pos, class_243 normal) {
        return bufferBuilder.method_1315(pos.field_1352, pos.field_1351, pos.field_1350).method_1315(normal.field_1352 * 127.0, normal.field_1351 * 127.0, normal.field_1350 * 127.0);
    }

    public void renderEdge(double fromOffset, double toOffset, int combinedLightFrom, int combinedLightTo, LineProjection p, class_287 bufferBuilder, double x, double y, double z) {
        int lightFrom1 = combinedLightFrom >> 16 & 0xFFFF;
        int lightFrom2 = combinedLightFrom & 0xFFFF;
        int lightTo1 = combinedLightTo >> 16 & 0xFFFF;
        int lightTo2 = combinedLightTo & 0xFFFF;
        double vFrom = fromOffset / 160.0;
        double vTo = toOffset / 160.0;
        for (int j = 0; j < 4; ++j) {
            double r1 = RIGHT_MULTIPLIERS[j];
            double r2 = RIGHT_MULTIPLIERS[j + 1];
            double u1 = UP_MULTIPLIERS[j];
            double u2 = UP_MULTIPLIERS[j + 1];
            double nr = NORMAL_RIGHT_MULTIPLIERS[j];
            double nu = NORMAL_UP_MULTIPLIERS[j];
            double uFrom = (4.0 - (double)j) / 4.0;
            double uTo = (3.0 - (double)j) / 4.0;
            class_243 normal = p.projectTangentRU(nr, nu);
            RenderClotheslineNetwork.posNormal(bufferBuilder, p.projectRUF((r1 - 4.0) / 32.0, u1 / 32.0, 0.0).method_1023(x, y, z), normal).method_1312(uFrom, vFrom).method_1313(lightFrom1, lightFrom2).method_1344();
            RenderClotheslineNetwork.posNormal(bufferBuilder, p.projectRUF((r2 - 4.0) / 32.0, u2 / 32.0, 0.0).method_1023(x, y, z), normal).method_1312(uTo, vFrom).method_1313(lightFrom1, lightFrom2).method_1344();
            RenderClotheslineNetwork.posNormal(bufferBuilder, p.projectRUF((r2 - 4.0) / 32.0, u2 / 32.0, 1.0).method_1023(x, y, z), normal).method_1312(uTo, vTo).method_1313(lightTo1, lightTo2).method_1344();
            RenderClotheslineNetwork.posNormal(bufferBuilder, p.projectRUF((r1 - 4.0) / 32.0, u1 / 32.0, 1.0).method_1023(x, y, z), normal).method_1312(uFrom, vTo).method_1313(lightTo1, lightTo2).method_1344();
        }
    }

    private void renderEdge(class_1920 world, NetworkEdge edge, double x, double y, double z, class_287 bufferBuilder, float delta) {
        Path.Edge ge = edge.getPathEdge();
        Line line = ge.getLine();
        int combinedLightFrom = world.method_8313(line.getFromPos(), 0);
        int combinedLightTo = world.method_8313(line.getToPos(), 0);
        double shift = edge.getNetwork().getState().getShift(delta);
        this.renderEdge((double)ge.getFromOffset() - shift, (double)ge.getToOffset() - shift, combinedLightFrom, combinedLightTo, LineProjection.create(edge), bufferBuilder, x, y, z);
    }

    public void buildAndDrawEdgeQuads(Consumer<class_287> consumer) {
        this.client.method_1531().method_4618(TEXTURE);
        class_308.method_1452();
        this.client.field_1773.method_3180();
        GlStateManager.enableCull();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(7, VERTEX_FORMAT);
        consumer.accept(bufferBuilder);
        tessellator.method_1350();
        GlStateManager.disableCull();
    }

    public void render(class_1920 world, RTreeMap<class_2338, NetworkNode> nodesMap, RTreeMap<Line, NetworkEdge> edgesMap, class_856 camera, double x, double y, double z, float delta) {
        class_243 viewPos = new class_243(x, y, z);
        Selection<NetworkNode> nodes = nodesMap.values(box -> camera.method_3699(new class_238((double)box.x1(), (double)box.y1(), (double)box.z1(), (double)box.x2(), (double)box.y2(), (double)box.z2())));
        this.client.method_1531().method_4618(class_1059.field_5275);
        this.client.method_1531().method_4619(class_1059.field_5275).method_4626(false, false);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        nodes.forEach(node -> {
            class_2338 pos = node.getPathNode().getPos();
            class_2680 state = world.method_8320(pos);
            if (state.method_11614() != ClotheslineBlocks.CLOTHESLINE_ANCHOR) {
                return;
            }
            int light = world.method_8313(pos, 0);
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)(light & 0xFFFF), (float)(light >> 16 & 0xFFFF));
            Network network = node.getNetwork();
            float shift = (float)network.getState().getShift() * delta + (float)network.getState().getPreviousShift() * (1.0f - delta);
            float crankRotation = -((float)node.getPathNode().getBaseRotation() + shift) * 360.0f / 160.0f;
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)((double)pos.method_10263() - x + 0.5), (double)((double)pos.method_10264() - y + 0.5), (double)((double)pos.method_10260() - z + 0.5));
            if (state.method_11654((class_2769)ClotheslineAnchorBlock.field_11007) == class_2738.field_12473) {
                GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                crankRotation = -crankRotation;
            }
            GlStateManager.rotatef((float)crankRotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)2.0f, (float)2.0f, (float)2.0f);
            ItemModelRenderer.renderModel(BakedModels.pulleyWheel, class_809.class_811.field_4319);
            if (!node.getNetwork().getState().getTree().isEmpty()) {
                ItemModelRenderer.renderModel(BakedModels.pulleyWheelRope, class_809.class_811.field_4319);
            }
            GlStateManager.popMatrix();
            if (((Boolean)state.method_11654(ClotheslineAnchorBlock.CRANK)).booleanValue()) {
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)0.0f, (float)0.25f, (float)0.0f);
                ItemModelRenderer.renderModel(BakedModels.crank, class_809.class_811.field_4319);
                GlStateManager.popMatrix();
            }
            GlStateManager.popMatrix();
        });
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableBlend();
        this.client.method_1531().method_4618(class_1059.field_5275);
        this.client.method_1531().method_4619(class_1059.field_5275).method_4627();
        Selection<NetworkEdge> edges = edgesMap.values(box -> camera.method_3699(new class_238((double)box.x1(), (double)box.y1(), (double)box.z1(), (double)box.x2(), (double)box.y2(), (double)box.z2())));
        this.buildAndDrawEdgeQuads(bufferBuilder -> edges.forEach(edge -> this.renderEdge(world, (NetworkEdge)edge, x, y, z, (class_287)bufferBuilder, delta)));
        GlStateManager.enableRescaleNormal();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableBlend();
        class_308.method_1452();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        class_1162 wPos = new class_1162();
        FloatBuffer l2wBuffer = class_311.method_1597((int)16);
        edges.forEach(edge -> {
            double toAttachmentKey;
            double fromAttachmentKey;
            Path.Edge pathEdge = edge.getPathEdge();
            NetworkState state = edge.getNetwork().getState();
            List<MutableSortedIntMap.Entry<class_1799>> attachments = state.getAttachmentsInRange((int)(fromAttachmentKey = state.offsetToAttachmentKey(pathEdge.getFromOffset(), delta)), (int)(toAttachmentKey = state.offsetToAttachmentKey(pathEdge.getToOffset(), delta)));
            if (!attachments.isEmpty()) {
                EdgeAttachmentProjector projector = EdgeAttachmentProjector.build(edge);
                for (MutableSortedIntMap.Entry<class_1799> attachmentEntry : attachments) {
                    double attachmentOffset = state.attachmentKeyToOffset(attachmentEntry.getKey(), delta);
                    class_1159 l2w = projector.getL2WForAttachment(state.getMomentum(delta), attachmentOffset, delta);
                    wPos.method_4955(0.0f, 0.0f, 0.0f, 1.0f);
                    wPos.method_4960(l2w);
                    int light = world.method_8313(new class_2338(class_3532.method_15375((float)wPos.method_4953()), class_3532.method_15375((float)wPos.method_4956()), class_3532.method_15375((float)wPos.method_4957())), 0);
                    GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)(light & 0xFFFF), (float)(light >> 16 & 0xFFFF));
                    l2w.method_4932(l2wBuffer);
                    l2wBuffer.flip();
                    GlStateManager.pushMatrix();
                    GlStateManager.translated((double)(-viewPos.field_1352), (double)(-viewPos.field_1351), (double)(-viewPos.field_1350));
                    GlStateManager.multMatrix((FloatBuffer)l2wBuffer);
                    this.client.method_1480().method_4009(attachmentEntry.getValue(), class_809.class_811.field_4319);
                    GlStateManager.popMatrix();
                    l2wBuffer.clear();
                }
            }
        });
        GlStateManager.disableRescaleNormal();
    }

    public void renderOutline(LineProjection p, double x, double y, double z, float r, float g, float b, float a) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(1, class_290.field_1576);
        for (int i = 0; i < 4; ++i) {
            double up = UP_MULTIPLIERS[i] * 1.01 / 32.0;
            double right = (RIGHT_MULTIPLIERS[i] * 1.01 - 4.0) / 32.0;
            RenderClotheslineNetwork.pos(bufferBuilder, p.projectRUF(right, up, 0.0).method_1023(x, y, z)).method_1336(r, g, b, a).method_1344();
            RenderClotheslineNetwork.pos(bufferBuilder, p.projectRUF(right, up, 1.0).method_1023(x, y, z)).method_1336(r, g, b, a).method_1344();
        }
        tessellator.method_1350();
    }

    private void debugRenderText(String msg, double x, double y, double z, float yaw, float pitch, class_327 fontRenderer) {
        class_757.method_3179((class_327)fontRenderer, (String)msg, (float)((float)x), (float)((float)y), (float)((float)z), (int)0, (float)yaw, (float)pitch, (boolean)false, (boolean)false);
    }

    public void debugRender(RTreeMap<class_2338, NetworkNode> nodesMap, RTreeMap<Line, NetworkEdge> edgesMap, class_856 camera, double x, double y, double z, float delta) {
        class_824 rendererDispatcher = class_824.field_4346;
        float yaw = rendererDispatcher.field_4354;
        float pitch = rendererDispatcher.field_4353;
        class_327 fontRenderer = class_310.method_1551().field_1772;
        Selection<NetworkEdge> edges = edgesMap.values(box -> camera.method_3699(new class_238((double)box.x1(), (double)box.y1(), (double)box.z1(), (double)box.x2(), (double)box.y2(), (double)box.z2())));
        edges.forEach(edge -> {
            Path.Edge pathEdge = edge.getPathEdge();
            class_2338 nodePos = pathEdge.getLine().getFromPos();
            NetworkNode node = (NetworkNode)nodesMap.get(nodePos);
            Path.Node pathNode = node.getPathNode();
            int nodeIndex = pathNode.getEdges().indexOf(pathEdge);
            class_243 pos = LineProjection.create(edge).projectRUF(-0.125, 0.125, 0.5);
            this.debugRenderText("L" + nodeIndex + " G" + edge.getIndex(), pos.field_1352 - x, pos.field_1351 - y, pos.field_1350 - z, yaw, pitch, fontRenderer);
        });
    }

    public void renderFirstPersonPlayerHeldClothesline(class_1657 player, double x, double y, double z, float delta) {
        ConnectorHolder connector = (ConnectorHolder)player;
        class_1838 from = connector.getFrom();
        if (from != null) {
            float pitch = (float)Math.toRadians(class_3532.method_16439((float)delta, (float)player.field_6004, (float)player.field_5965));
            float yaw = (float)Math.toRadians(class_3532.method_16439((float)delta, (float)player.field_5982, (float)player.field_6031));
            int k = player.method_6068() == class_1306.field_6183 ? 1 : -1;
            double f10 = this.client.field_1690.field_1826 / 100.0;
            class_243 vecB = new class_243(x, y + (double)player.method_5751(), z).method_1019(new class_243((double)k * -0.36 * f10, -0.045 * f10, 0.4).method_1037(-pitch).method_1024(-yaw));
            this.renderHeldClothesline(from.method_8037(), vecB, (class_1920)player.field_6002, x, y, z);
        }
    }

    public void renderThirdPersonPlayerHeldClothesline(class_1657 player, double x, double y, double z, float delta) {
        ConnectorHolder connector = (ConnectorHolder)player;
        class_1838 from = connector.getFrom();
        if (from != null) {
            double posX = class_3532.method_16436((double)delta, (double)player.field_6038, (double)player.field_5987);
            double posY = class_3532.method_16436((double)delta, (double)player.field_5971, (double)player.field_6010);
            double posZ = class_3532.method_16436((double)delta, (double)player.field_5989, (double)player.field_6035);
            float yaw = (float)Math.toRadians(class_3532.method_16439((float)delta, (float)player.field_5982, (float)player.field_6031));
            int k = player.method_6068() == class_1306.field_6183 ? 1 : -1;
            double d0 = (double)class_3532.method_15374((float)yaw) * 0.35;
            double d1 = (double)class_3532.method_15362((float)yaw) * 0.35;
            class_243 vecB = new class_243(posX - d0 - d1 * (double)k, posY + (player.method_5715() ? 0.4 : 0.9), posZ - d0 * (double)k + d1);
            this.renderHeldClothesline(from.method_8037(), vecB, (class_1920)player.field_6002, x, y, z);
        }
    }

    private void renderHeldClothesline(class_2338 posA, class_243 vecB, class_1920 world, double x, double y, double z) {
        class_243 vecA = Utility.midVec(posA);
        class_2338 posB = new class_2338(vecB);
        int combinedLightA = world.method_8313(posA, 0);
        int combinedLightB = world.method_8313(posB, 0);
        double length = 160.0 * vecB.method_1022(vecA);
        this.buildAndDrawEdgeQuads(bufferBuilder -> {
            this.renderEdge(0.0, length, combinedLightA, combinedLightB, LineProjection.create(vecA, vecB), (class_287)bufferBuilder, x, y, z);
            this.renderEdge(-length, 0.0, combinedLightB, combinedLightA, LineProjection.create(vecB, vecA), (class_287)bufferBuilder, x, y, z);
        });
    }
}

